/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.connections.actions;

import java.util.Iterator;
import net.sourceforge.sqlexplorer.AliasModel;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.SQLAlias;
import net.sourceforge.sqlexplorer.connections.actions.AbstractConnectionTreeAction;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DeleteAliasAction
extends AbstractConnectionTreeAction {
    ImageDescriptor _image = ImageUtil.getDescriptor("Images.DeleteAlias");

    public String getToolTipText() {
        return Messages.getString("ConnectionsView.Actions.DeleteAliasToolTip");
    }

    public String getText() {
        return Messages.getString("ConnectionsView.Actions.DeleteAlias");
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return this._image;
    }

    public ImageDescriptor getImageDescriptor() {
        return this._image;
    }

    public void run() {
        boolean okToDelete = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("ConnectionsView.ConfirmDelete.WindowTitle"), (String)Messages.getString("ConnectionsView.ConfirmDelete.Message"));
        if (!okToDelete) {
            return;
        }
        StructuredSelection sel = (StructuredSelection)this._treeViewer.getSelection();
        AliasModel aliasModel = SQLExplorerPlugin.getDefault().getAliasModel();
        Iterator it = sel.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof SQLAlias)) continue;
            aliasModel.removeAlias((SQLAlias)o);
        }
        this._treeViewer.refresh();
    }

    public boolean isAvailable() {
        StructuredSelection sel = (StructuredSelection)this._treeViewer.getSelection();
        if (sel.size() == 0) {
            return false;
        }
        Iterator it = sel.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof ISQLAlias)) continue;
            return true;
        }
        return false;
    }
}

