/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.connections.actions;

import java.util.Iterator;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.SQLAlias;
import net.sourceforge.sqlexplorer.connections.actions.AbstractConnectionTreeAction;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.actions.OpenPasswordConnectDialogAction;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditorInput;
import net.sourceforge.sqlexplorer.plugin.views.ConnectionsView;
import net.sourceforge.sqlexplorer.sessiontree.model.RootSessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;

public class NewEditorAction
extends AbstractConnectionTreeAction
implements IViewActionDelegate {
    ImageDescriptor _image = ImageUtil.getDescriptor("Images.OpenSQLIcon");
    ImageDescriptor _disabledImage = ImageUtil.getDescriptor("Images.AliasIcon");

    public ImageDescriptor getHoverImageDescriptor() {
        return this._image;
    }

    public ImageDescriptor getImageDescriptor() {
        return this._image;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return this._disabledImage;
    }

    public void init(IViewPart view) {
        this._treeViewer = ((ConnectionsView)view).getTreeViewer();
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.isAvailable());
    }

    public String getText() {
        return Messages.getString("ConnectionsView.Actions.NewEditor");
    }

    public String getToolTipText() {
        return Messages.getString("ConnectionsView.Actions.NewEditorToolTip");
    }

    public void run() {
        StructuredSelection sel = (StructuredSelection)this._treeViewer.getSelection();
        Iterator it = sel.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof SQLAlias) {
                boolean okToOpen;
                ISQLAlias al = (ISQLAlias)o;
                SessionTreeNode node = null;
                RootSessionTreeNode sessionRoot = SQLExplorerPlugin.getDefault().stm.getRoot();
                Object[] sessions = sessionRoot.getChildren();
                if (sessions != null) {
                    int i = 0;
                    while (i < sessions.length) {
                        SessionTreeNode session = (SessionTreeNode)sessions[i];
                        if (session.getAlias().getIdentifier().equals((Object)al.getIdentifier())) {
                            node = session;
                            break;
                        }
                        ++i;
                    }
                }
                if (node == null && (okToOpen = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("ConnectionsView.Actions.NewEditor.Connect.WindowTitle"), (String)Messages.getString("ConnectionsView.Actions.NewEditor.Connect.Message")))) {
                    OpenPasswordConnectDialogAction openDlgAction = new OpenPasswordConnectDialogAction(this._view.getSite(), al, SQLExplorerPlugin.getDefault().getDriverModel(), SQLExplorerPlugin.getDefault().getPreferenceStore(), SQLExplorerPlugin.getDefault().getSQLDriverManager());
                    openDlgAction.run();
                    sessions = sessionRoot.getChildren();
                    if (sessions != null) {
                        int i = 0;
                        while (i < sessions.length) {
                            SessionTreeNode session = (SessionTreeNode)sessions[i];
                            if (session.getAlias().getIdentifier().equals((Object)al.getIdentifier())) {
                                node = session;
                                break;
                            }
                            ++i;
                        }
                    }
                }
                SQLEditorInput input = new SQLEditorInput("SQL Editor (" + SQLExplorerPlugin.getDefault().getNextElement() + ").sql");
                input.setSessionNode(node);
                IWorkbenchPage page = SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor((IEditorInput)input, "net.sourceforge.sqlexplorer.plugin.editors.SQLEditor");
                }
                catch (Throwable e) {
                    SQLExplorerPlugin.error("Error creating sql editor", e);
                }
            }
            if (!(o instanceof SessionTreeNode)) continue;
            SessionTreeNode node = (SessionTreeNode)o;
            SQLEditorInput input = new SQLEditorInput("SQL Editor (" + SQLExplorerPlugin.getDefault().getNextElement() + ").sql");
            input.setSessionNode(node);
            IWorkbenchPage page = SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                page.openEditor((IEditorInput)input, "net.sourceforge.sqlexplorer.plugin.editors.SQLEditor");
            }
            catch (Throwable e) {
                SQLExplorerPlugin.error("Error creating sql editor", e);
            }
        }
        this._treeViewer.refresh();
    }

    public boolean isAvailable() {
        StructuredSelection sel = (StructuredSelection)this._treeViewer.getSelection();
        return sel.size() > 0;
    }
}

