/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dataset;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import net.sourceforge.sqlexplorer.dataset.DataSetRow;
import net.sourceforge.sqlexplorer.dataset.DataSetTableSorter;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;

public class DataSet {
    public static final int TYPE_DATE = 3;
    public static final int TYPE_DATETIME = 4;
    public static final int TYPE_DOUBLE = 1;
    public static final int TYPE_INTEGER = 2;
    public static final int TYPE_LONG = 6;
    public static final int TYPE_STRING = 0;
    public static final int TYPE_TIME = 5;
    private String[] _columnLabels;
    private int[] _columnTypes;
    private DataSetRow[] _rows;
    private DataSetTableSorter _sorter;

    private DataSet() {
    }

    public DataSet(String[] columnLabels, ResultSet resultSet, int[] relevantIndeces) throws Exception {
        this.initialize(columnLabels, resultSet, relevantIndeces);
    }

    public DataSet(String[] columnLabels, String sql, int[] relevantIndeces, SQLConnection connection) throws Exception {
        Statement statement = connection.createStatement();
        statement.execute(sql);
        ResultSet resultSet = statement.getResultSet();
        this.initialize(columnLabels, resultSet, relevantIndeces);
        statement.close();
    }

    public DataSet(String[] columnLabels, String[][] data, int[] columnTypes) throws Exception {
        this._columnLabels = columnLabels;
        this._columnTypes = columnTypes;
        this._rows = new DataSetRow[data.length];
        int i = 0;
        while (i < data.length) {
            this._rows[i] = new DataSetRow(data[i]);
            ++i;
        }
    }

    public int getColumnIndex(String name) {
        int i = 0;
        while (i < this._columnLabels.length) {
            if (this._columnLabels[i].equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public String[] getColumnLabels() {
        return this._columnLabels;
    }

    public int[] getColumnTypes() {
        return this._columnTypes;
    }

    public DataSetRow[] getRows() {
        return this._rows;
    }

    private void initialize(String[] columnLabels, ResultSet resultSet, int[] relevantIndeces) throws Exception {
        int i;
        ResultSetMetaData metadata = resultSet.getMetaData();
        if (relevantIndeces == null || relevantIndeces.length == 0) {
            relevantIndeces = new int[metadata.getColumnCount()];
            i = 1;
            while (i <= metadata.getColumnCount()) {
                relevantIndeces[i - 1] = i;
                ++i;
            }
        }
        if (columnLabels != null && columnLabels.length != 0) {
            this._columnLabels = columnLabels;
        } else {
            this._columnLabels = new String[relevantIndeces.length];
            i = 0;
            while (i < relevantIndeces.length) {
                this._columnLabels[i] = metadata.getColumnName(relevantIndeces[i]);
                ++i;
            }
        }
        this._columnTypes = new int[relevantIndeces.length];
        i = 0;
        while (i < relevantIndeces.length) {
            switch (metadata.getColumnType(relevantIndeces[i])) {
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    this._columnTypes[i] = 0;
                    break;
                }
                case -6: 
                case 4: 
                case 5: {
                    this._columnTypes[i] = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    this._columnTypes[i] = 1;
                    break;
                }
                case 91: 
                case 93: {
                    this._columnTypes[i] = 4;
                    break;
                }
                case 92: {
                    this._columnTypes[i] = 5;
                    break;
                }
                case -5: {
                    this._columnTypes[i] = 6;
                    break;
                }
                default: {
                    this._columnTypes[i] = 0;
                }
            }
            ++i;
        }
        ArrayList<DataSetRow> rows = new ArrayList<DataSetRow>(100);
        while (resultSet.next()) {
            DataSetRow row = new DataSetRow(relevantIndeces.length);
            int i2 = 0;
            while (i2 < relevantIndeces.length) {
                switch (this._columnTypes[i2]) {
                    case 0: {
                        row.setValue(i2, resultSet.getString(relevantIndeces[i2]));
                        break;
                    }
                    case 2: {
                        row.setValue(i2, new Long(resultSet.getInt(relevantIndeces[i2])));
                        break;
                    }
                    case 1: {
                        row.setValue(i2, new Double(resultSet.getDouble(relevantIndeces[i2])));
                        break;
                    }
                    case 3: {
                        row.setValue(i2, resultSet.getDate(relevantIndeces[i2]));
                        break;
                    }
                    case 4: {
                        row.setValue(i2, resultSet.getTimestamp(relevantIndeces[i2]));
                        break;
                    }
                    case 5: {
                        row.setValue(i2, resultSet.getTime(relevantIndeces[i2]));
                        break;
                    }
                    case 6: {
                        row.setValue(i2, new Long(resultSet.getLong(relevantIndeces[i2])));
                        break;
                    }
                    default: {
                        row.setValue(i2, resultSet.getString(relevantIndeces[i2]));
                    }
                }
                if (resultSet.wasNull()) {
                    row.setValue(i2, null);
                }
                ++i2;
            }
            rows.add(row);
        }
        this._rows = rows.toArray(new DataSetRow[0]);
    }

    public void sort(int columnIndex, int sortDirection) {
        if (this._sorter == null) {
            this._sorter = new DataSetTableSorter(this);
        }
        this._sorter.setTopPriority(columnIndex, sortDirection);
        Arrays.sort(this._rows, this._sorter);
    }
}

