/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dataset;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dataset.DataSet;
import net.sourceforge.sqlexplorer.dataset.DataSetTableActionGroup;
import net.sourceforge.sqlexplorer.dataset.DataSetTableContentProvider;
import net.sourceforge.sqlexplorer.dataset.DataSetTableKeyListener;
import net.sourceforge.sqlexplorer.dataset.DataSetTableLabelProvider;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class DataSetTable {
    private DataSetTable() {
    }

    public DataSetTable(Composite parent, final DataSet dataSet, String info) throws Exception {
        Composite composite = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginLeft = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gridData);
        String[] columnLabels = dataSet.getColumnLabels();
        int[] columnTypes = dataSet.getColumnTypes();
        if (columnLabels == null || columnTypes == null || columnLabels.length == 0 || columnTypes.length == 0 || columnTypes.length != columnLabels.length) {
            throw new Exception("Invalid columnLabel or columnTypes in DataSet ");
        }
        TableViewer tableViewer = new TableViewer(composite, 268438274);
        final Table table = tableViewer.getTable();
        tableViewer.setColumnProperties(columnLabels);
        table.setItemCount(dataSet.getRows().length);
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                TableColumn sortColumn = table.getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = table.getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    table.setSortColumn(currentColumn);
                    dir = 128;
                }
                dataSet.sort((Integer)currentColumn.getData("orignalColumnIndex"), dir);
                table.setSortDirection(dir);
                table.clearAll();
            }
        };
        GridData tGridData = new GridData();
        tGridData.horizontalSpan = 2;
        tGridData.grabExcessHorizontalSpace = true;
        tGridData.grabExcessVerticalSpace = true;
        tGridData.horizontalAlignment = 4;
        tGridData.verticalAlignment = 4;
        table.setLayoutData((Object)tGridData);
        GridLayout tlayout = new GridLayout();
        tlayout.numColumns = 2;
        tlayout.marginLeft = 0;
        table.setLayout((Layout)tlayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setData((Object)dataSet);
        int i = 0;
        while (i < columnLabels.length) {
            TableColumn column = new TableColumn(table, 16384);
            column.setText(columnLabels[i]);
            column.setMoveable(true);
            column.setResizable(true);
            column.addListener(13, sortListener);
            column.setData("orignalColumnIndex", (Object)new Integer(i));
            ++i;
        }
        tableViewer.setContentProvider((IContentProvider)new DataSetTableContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new DataSetTableLabelProvider());
        tableViewer.setInput((Object)dataSet);
        i = 0;
        while (i < table.getColumnCount()) {
            table.getColumn(i).pack();
            ++i;
        }
        Label infoLabel = new Label(composite, 0);
        infoLabel.setText(info);
        infoLabel.setLayoutData((Object)new GridData(16384, 0, true, false));
        final Label positionLabel = new Label(composite, 0);
        positionLabel.setText("");
        positionLabel.setLayoutData((Object)new GridData(131072, 0, true, false));
        final TableCursor cursor = new TableCursor(table, 0);
        cursor.setBackground(table.getDisplay().getSystemColor(26));
        cursor.setForeground(table.getDisplay().getSystemColor(27));
        cursor.setLayout((Layout)new FillLayout());
        cursor.setVisible(false);
        cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                table.setSelection(new TableItem[]{cursor.getRow()});
                cursor.setVisible(true);
                positionLabel.setText(String.valueOf(Messages.getString("DatabaseDetailView.Tab.RowPrefix")) + " " + (table.indexOf(cursor.getRow()) + 1) + Messages.getString("DatabaseDetailView.Tab.ColumnPrefix") + " " + (cursor.getColumn() + 1));
                positionLabel.getParent().layout();
                positionLabel.redraw();
            }
        });
        cursor.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (cursor != null) {
                    if (cursor.getRow() == null) {
                        cursor.setVisible(false);
                    } else {
                        cursor.layout();
                        cursor.redraw();
                        cursor.setVisible(true);
                    }
                }
            }
        });
        table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Table t = (Table)e.widget;
                if (t.getItemCount() != 0) {
                    cursor.setVisible(true);
                }
            }
        });
        DataSetTableKeyListener keyListener = new DataSetTableKeyListener(parent, table, cursor);
        cursor.addKeyListener((KeyListener)keyListener);
        table.addKeyListener((KeyListener)keyListener);
        final DataSetTableActionGroup actionGroup = new DataSetTableActionGroup(table, cursor);
        MenuManager menuManager = new MenuManager("DataSetTableContextMenu");
        menuManager.setRemoveAllWhenShown(true);
        Menu contextMenu = menuManager.createContextMenu((Control)table);
        tableViewer.getControl().setMenu(contextMenu);
        cursor.setMenu(contextMenu);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                actionGroup.fillContextMenu(manager);
            }
        });
    }
}

