/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dataset;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dataset.actions.AbstractDataSetTableContextAction;
import net.sourceforge.sqlexplorer.dataset.actions.CopyTableAction;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.actions.ActionGroup;

public class DataSetTableActionGroup
extends ActionGroup {
    private Table _table;
    private TableCursor _cursor;
    private CopyTableAction _copyTableAction;

    public DataSetTableActionGroup(Table table, TableCursor cursor) {
        this._table = table;
        this._cursor = cursor;
        this._copyTableAction = new CopyTableAction();
        this._copyTableAction.setTable(this._table);
        this._copyTableAction.setTableCursor(this._cursor);
    }

    public void fillContextMenu(IMenuManager menu) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("net.sourceforge.sqlexplorer", "dataSetTableContextAction");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension e = extensions[i];
            IConfigurationElement[] ces = e.getConfigurationElements();
            int j = 0;
            while (j < ces.length) {
                try {
                    String group = ces[j].getAttribute("group");
                    if (group == null || !group.equalsIgnoreCase("export")) {
                        AbstractDataSetTableContextAction action = (AbstractDataSetTableContextAction)((Object)ces[j].createExecutableExtension("class"));
                        action.setTable(this._table);
                        action.setTableCursor(this._cursor);
                        if (action.isAvailable()) {
                            menu.add((IAction)action);
                        }
                    }
                }
                catch (Throwable ex) {
                    SQLExplorerPlugin.error("Could not create menu action", ex);
                }
                ++j;
            }
            ++i;
        }
        menu.add((IContributionItem)new Separator());
        MenuManager subMenu = new MenuManager(Messages.getString("DataSetTable.Actions.ExportSubMenu"));
        int i2 = 0;
        while (i2 < extensions.length) {
            IExtension e = extensions[i2];
            IConfigurationElement[] ces = e.getConfigurationElements();
            int j = 0;
            while (j < ces.length) {
                try {
                    String group = ces[j].getAttribute("group");
                    if (group != null && group.equalsIgnoreCase("export")) {
                        AbstractDataSetTableContextAction action = (AbstractDataSetTableContextAction)((Object)ces[j].createExecutableExtension("class"));
                        action.setTable(this._table);
                        action.setTableCursor(this._cursor);
                        if (action.isAvailable()) {
                            subMenu.add((IAction)action);
                        }
                    }
                }
                catch (Throwable ex) {
                    SQLExplorerPlugin.error("Could not create menu action", ex);
                }
                ++j;
            }
            ++i2;
        }
        menu.add((IContributionItem)subMenu);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this._copyTableAction);
    }
}

