/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dataset;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbdetail.IDetailTab;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sqlpanel.SQLExecution;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DataSetTableKeyListener
implements KeyListener {
    private IDetailTab _tab = null;
    private Composite _parent = null;
    private Table _table = null;
    private TableCursor _cursor = null;
    private Shell _popup = null;
    private static final int CTRL_C = 3;
    private static final int CTRL_F = 6;
    private static final int ENTER = 13;
    private String _lastNameSearched = null;
    private int _lastColumnIndex = 0;

    public DataSetTableKeyListener(Composite parent, Table table, TableCursor cursor) {
        this._table = table;
        this._parent = parent;
        this._cursor = cursor;
        Object o = this._parent.getData("IDetailTab");
        if (o != null) {
            this._tab = (IDetailTab)o;
        }
    }

    public void keyPressed(KeyEvent e) {
        switch (e.character) {
            case '\u0003': {
                try {
                    Clipboard clipBoard = new Clipboard(Display.getCurrent());
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    TableItem[] items = this._table.getSelection();
                    if (items == null || items.length == 0) {
                        return;
                    }
                    int columnIndex = this._cursor.getColumn();
                    clipBoard.setContents(new Object[]{items[0].getText(columnIndex)}, new Transfer[]{textTransfer});
                }
                catch (Exception ex) {
                    SQLExplorerPlugin.error("Error exporting cell to clipboard ", ex);
                }
                break;
            }
            case '\u0006': {
                this.createPopup();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        switch (e.keyCode) {
            case 0x100000E: {
                if (this._tab != null) {
                    this._tab.refresh();
                }
                this.disposePopup();
                try {
                    SQLExecution sqlExec;
                    Object o = this._parent.getData("parenttab");
                    if (o == null || (sqlExec = (SQLExecution)((TabItem)o).getData()) == null) break;
                    sqlExec.startExecution();
                }
                catch (Exception e1) {
                    SQLExplorerPlugin.error("Error refreshing", e1);
                }
                break;
            }
            case 27: {
                this.disposePopup();
            }
        }
    }

    private void createPopup() {
        this._lastNameSearched = null;
        if (this._popup != null && !this._popup.isDisposed()) {
            if (!this._popup.isVisible()) {
                this._popup.open();
            }
            return;
        }
        Point popupLocation = this._table.toDisplay(10, 40);
        this._popup = new Shell(this._parent.getShell(), 18432);
        this._popup.setBackground(this._parent.getDisplay().getSystemColor(29));
        this._popup.setForeground(this._parent.getDisplay().getSystemColor(28));
        this._popup.setSize(250, 50);
        this._popup.setLocation(popupLocation);
        this._popup.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        Label label = new Label((Composite)this._popup, 0);
        label.setText(Messages.getString("DataSetTable.PopUp.Find"));
        label.setBackground(this._parent.getDisplay().getSystemColor(29));
        final Text input = new Text((Composite)this._popup, 4);
        input.setLayoutData((Object)gridData);
        input.setBackground(this._parent.getDisplay().getSystemColor(29));
        input.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.widget;
                String text = t.getText();
                if (DataSetTableKeyListener.this.jumpToColumn(text)) {
                    input.setForeground(DataSetTableKeyListener.this._parent.getDisplay().getSystemColor(28));
                } else {
                    input.setForeground(DataSetTableKeyListener.this._parent.getDisplay().getSystemColor(3));
                }
            }
        });
        input.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    if (DataSetTableKeyListener.this.jumpToColumn(null)) {
                        input.setForeground(DataSetTableKeyListener.this._parent.getDisplay().getSystemColor(28));
                    } else {
                        input.setForeground(DataSetTableKeyListener.this._parent.getDisplay().getSystemColor(3));
                    }
                }
            }
        });
        input.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DataSetTableKeyListener.this.disposePopup();
            }
        });
        this._popup.open();
        this._popup.forceActive();
    }

    private void disposePopup() {
        if (this._popup != null && !this._popup.isDisposed()) {
            this._popup.close();
            this._popup.dispose();
            this._popup = null;
        }
    }

    private boolean jumpToColumn(String name) {
        TableColumn[] columns;
        String text = null;
        if (name != null) {
            this._lastNameSearched = text = name.toLowerCase().trim();
            this._lastColumnIndex = 0;
        } else {
            text = this._lastNameSearched;
            ++this._lastColumnIndex;
        }
        if (text == null) {
            text = "";
        }
        if ((columns = this._table.getColumns()) == null || this._lastColumnIndex >= columns.length) {
            this._lastColumnIndex = 0;
            return false;
        }
        boolean columnFound = false;
        int i = this._lastColumnIndex;
        while (i < columns.length) {
            TableColumn column = columns[i];
            if (column.getText().toLowerCase().startsWith(text)) {
                columnFound = true;
                this._table.showColumn(columns[columns.length - 1]);
                this._table.showColumn(column);
                if (this._table.getItemCount() > 0) {
                    this._cursor.setSelection(0, i);
                    this._cursor.setVisible(true);
                }
                this._lastColumnIndex = i;
                break;
            }
            ++i;
        }
        if (!columnFound) {
            this._lastColumnIndex = 0;
        }
        return columnFound;
    }
}

