/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dataset.actions;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dataset.actions.AbstractDataSetTableContextAction;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class CopyColumnNameAction
extends AbstractDataSetTableContextAction {
    private static final ImageDescriptor _image = ImageUtil.getDescriptor("Images.ExportToClipBoardIcon");

    public String getText() {
        return Messages.getString("DataSetTable.Actions.CopyColumnName");
    }

    public ImageDescriptor getImageDescriptor() {
        return _image;
    }

    public void run() {
        try {
            Clipboard clipBoard = new Clipboard(Display.getCurrent());
            TextTransfer textTransfer = TextTransfer.getInstance();
            TableItem[] items = this._table.getSelection();
            if (items == null || items.length == 0) {
                return;
            }
            int columnIndex = this._cursor.getColumn();
            TableColumn column = this._table.getColumn(columnIndex);
            clipBoard.setContents(new Object[]{column.getText()}, new Transfer[]{textTransfer});
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Error exporting cell to clipboard ", e);
        }
    }

    public boolean isAvailable() {
        return this._table.getSelectionIndex() != -1;
    }
}

