/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dataset.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dataset.DataSet;
import net.sourceforge.sqlexplorer.dataset.actions.AbstractDataSetTableContextAction;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class ExportCSVAction
extends AbstractDataSetTableContextAction {
    private static final ImageDescriptor _image = ImageUtil.getDescriptor("Images.ExportIcon");

    public String getText() {
        return Messages.getString("DataSetTable.Actions.Export.CSV");
    }

    public ImageDescriptor getImageDescriptor() {
        return _image;
    }

    public void run() {
        FileDialog fileDialog = new FileDialog(this._table.getShell(), 8192);
        String[] filterExtensions = new String[]{"*.csv"};
        fileDialog.setFilterExtensions(filterExtensions);
        final String fileName = fileDialog.open();
        if (fileName == null && fileName.trim().length() == 0) {
            return;
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    int i;
                    File file = new File(fileName);
                    if (file.exists()) {
                        file.delete();
                    }
                    file.createNewFile();
                    BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                    StringBuffer buffer = new StringBuffer("");
                    String columnSeparator = SQLExplorerPlugin.getDefault().getPreferenceStore().getString("SQLEditor.ClipExportSeparator");
                    boolean includeColumnNames = SQLExplorerPlugin.getDefault().getPreferenceStore().getBoolean("SQLEditor.ClipExportColumns");
                    TableItem[] items = ExportCSVAction.this._table.getItems();
                    DataSet dataSet = (DataSet)ExportCSVAction.this._table.getData();
                    if (items == null || dataSet == null) {
                        return;
                    }
                    if (includeColumnNames) {
                        String[] columnNames = dataSet.getColumnLabels();
                        i = 0;
                        while (i < columnNames.length) {
                            buffer.append(columnNames[i]);
                            buffer.append(columnSeparator);
                            ++i;
                        }
                        writer.write(buffer.toString(), 0, buffer.length());
                        writer.newLine();
                    }
                    int columnCount = ExportCSVAction.this._table.getColumnCount();
                    i = 0;
                    while (i < items.length) {
                        buffer = new StringBuffer("");
                        int j = 0;
                        while (j < columnCount) {
                            buffer.append(items[i].getText(j));
                            buffer.append(columnSeparator);
                            ++j;
                        }
                        writer.write(buffer.toString(), 0, buffer.length());
                        writer.newLine();
                        ++i;
                    }
                    writer.close();
                }
                catch (Exception e) {
                    ExportCSVAction.this._table.getShell().getDisplay().asyncExec(new Runnable(this, e){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ Exception val$e;
                        {
                            this.this$1 = var1_1;
                            this.val$e = exception;
                        }

                        public void run() {
                            MessageDialog.openError((Shell)1.access$0(this.this$1)._table.getShell(), (String)Messages.getString("SQLResultsView.Error.Export.Title"), (String)this.val$e.getMessage());
                        }
                    });
                }
            }

            static /* synthetic */ ExportCSVAction access$0(1 var0) {
                return var0.ExportCSVAction.this;
            }
        });
    }
}

