/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dataset.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dataset.DataSet;
import net.sourceforge.sqlexplorer.dataset.actions.AbstractDataSetTableContextAction;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class ExportHTMLAction
extends AbstractDataSetTableContextAction {
    private static final ImageDescriptor _image = ImageUtil.getDescriptor("Images.ExportIcon");

    public String getText() {
        return Messages.getString("DataSetTable.Actions.Export.HTML");
    }

    public ImageDescriptor getImageDescriptor() {
        return _image;
    }

    public void run() {
        FileDialog fileDialog = new FileDialog(this._table.getShell(), 8192);
        String[] filterExtensions = new String[]{"*.htm", "*.html"};
        fileDialog.setFilterExtensions(filterExtensions);
        final String fileName = fileDialog.open();
        if (fileName == null && fileName.trim().length() == 0) {
            return;
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    File file = new File(fileName);
                    if (file.exists()) {
                        file.delete();
                    }
                    file.createNewFile();
                    BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                    StringBuffer buffer = new StringBuffer("");
                    boolean includeColumnNames = SQLExplorerPlugin.getDefault().getPreferenceStore().getBoolean("SQLEditor.ClipExportColumns");
                    TableItem[] items = ExportHTMLAction.this._table.getItems();
                    DataSet dataSet = (DataSet)ExportHTMLAction.this._table.getData();
                    if (items == null || dataSet == null) {
                        return;
                    }
                    writer.write("<html>");
                    writer.newLine();
                    writer.write("<style>");
                    writer.write("TABLE {border-collapse: collapse;}");
                    writer.write("TH {background-color: rgb(240, 244, 245);}");
                    writer.write("TH, TD {border: 1px solid #D1D6D4;font-size: 10px;font-family: Verdana, Arial, Helvetica, sans-serif;}");
                    writer.write(".right {text-align: right;}");
                    writer.write("</style>");
                    writer.write("</head>");
                    writer.write("<table>");
                    writer.newLine();
                    if (includeColumnNames) {
                        buffer.append("<tr>");
                        String[] columnNames = dataSet.getColumnLabels();
                        int i = 0;
                        while (i < columnNames.length) {
                            buffer.append("<th>");
                            buffer.append(columnNames[i]);
                            buffer.append("</th>");
                            ++i;
                        }
                        buffer.append("</tr>");
                        writer.write(buffer.toString());
                        writer.newLine();
                    }
                    DataSet set = (DataSet)ExportHTMLAction.this._table.getData();
                    int columnCount = ExportHTMLAction.this._table.getColumnCount();
                    int i = 0;
                    while (i < items.length) {
                        buffer = new StringBuffer("<tr>");
                        int j = 0;
                        while (j < columnCount) {
                            if (set.getColumnTypes()[j] == 1 || set.getColumnTypes()[j] == 2) {
                                buffer.append("<td class=\"right\">");
                            } else {
                                buffer.append("<td>");
                            }
                            buffer.append(items[i].getText(j));
                            buffer.append("</td>");
                            ++j;
                        }
                        buffer.append("</tr>");
                        writer.write(buffer.toString());
                        writer.newLine();
                        ++i;
                    }
                    writer.write("</table>");
                    writer.newLine();
                    writer.write("</html>");
                    writer.newLine();
                    writer.close();
                }
                catch (Exception e) {
                    ExportHTMLAction.this._table.getShell().getDisplay().asyncExec(new Runnable(this, e){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ Exception val$e;
                        {
                            this.this$1 = var1_1;
                            this.val$e = exception;
                        }

                        public void run() {
                            MessageDialog.openError((Shell)1.access$0(this.this$1)._table.getShell(), (String)Messages.getString("SQLResultsView.Error.Export.Title"), (String)this.val$e.getMessage());
                            SQLExplorerPlugin.error(Messages.getString("SQLResultsView.Error.Export.Title"), this.val$e);
                        }
                    });
                }
            }

            static /* synthetic */ ExportHTMLAction access$0(1 var0) {
                return var0.ExportHTMLAction.this;
            }
        });
    }
}

