/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbdetail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbdetail.IDetailTab;
import net.sourceforge.sqlexplorer.dbdetail.tab.ColumnInfoTab;
import net.sourceforge.sqlexplorer.dbdetail.tab.ColumnPriviligesTab;
import net.sourceforge.sqlexplorer.dbdetail.tab.ConnectionInfoTab;
import net.sourceforge.sqlexplorer.dbdetail.tab.ExportedKeysTab;
import net.sourceforge.sqlexplorer.dbdetail.tab.ImportedKeysTab;
import net.sourceforge.sqlexplorer.dbdetail.tab.IndexesTab;
import net.sourceforge.sqlexplorer.dbdetail.tab.PreviewTab;
import net.sourceforge.sqlexplorer.dbdetail.tab.PrimaryKeysTab;
import net.sourceforge.sqlexplorer.dbdetail.tab.PriviligesTab;
import net.sourceforge.sqlexplorer.dbdetail.tab.RowCountTab;
import net.sourceforge.sqlexplorer.dbdetail.tab.RowIdsTab;
import net.sourceforge.sqlexplorer.dbdetail.tab.TableInfoTab;
import net.sourceforge.sqlexplorer.dbdetail.tab.VersionsTab;
import net.sourceforge.sqlexplorer.dbstructure.nodes.DatabaseNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.sqlexplorer.util.TextUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class DetailTabManager {
    private static String _activeTabName = null;
    private static final Log _logger;
    private static final HashMap _sessionTabCache;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.sqlexplorer.dbdetail.DetailTabManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _logger = LogFactory.getLog((Class)clazz);
        _sessionTabCache = new HashMap();
    }

    public static void clearCacheForNode(INode node) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Clearing tab cache for: " + node.getUniqueIdentifier()));
        }
        HashMap tabCache = (HashMap)_sessionTabCache.get(node.getSession());
        tabCache.remove(node.getUniqueIdentifier());
    }

    public static void clearCacheForSession(SessionTreeNode session) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Clearing tab cache for: " + session.toString()));
        }
        _sessionTabCache.remove(session);
    }

    public static void createTabs(Composite composite, INode node) {
        TabItem tabItem;
        List tabs = DetailTabManager.getTabs(node);
        if (tabs == null || tabs.size() == 0) {
            Label label = new Label(composite, 4);
            label.setText(String.valueOf(Messages.getString("DatabaseDetailView.Tab.Unavailable")) + " " + node.getLabelText());
            label.setLayoutData((Object)new GridData(4, 128, true, false));
            return;
        }
        TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TabItem tabItem = (TabItem)e.item;
                IDetailTab tab = (IDetailTab)tabItem.getData();
                if (tab != null) {
                    Composite detailComposite = new Composite((Composite)tabItem.getParent(), 4);
                    tabItem.setControl((Control)detailComposite);
                    detailComposite.setLayout((Layout)new FillLayout());
                    tab.fillComposite(detailComposite);
                    detailComposite.layout();
                    DetailTabManager.setActiveTabName(tabItem.getText());
                }
            }
        });
        Iterator it = tabs.iterator();
        int tabIndex = 0;
        while (it.hasNext()) {
            IDetailTab detailTab = (IDetailTab)it.next();
            TabItem tabItem2 = new TabItem(tabFolder, 0);
            tabItem2.setText(detailTab.getLabelText());
            tabItem2.setToolTipText(detailTab.getLabelToolTipText());
            tabItem2.setData((Object)detailTab);
            if (tabItem2.getText() != null && _activeTabName != null && tabItem2.getText().equals(_activeTabName)) {
                tabFolder.setSelection(tabIndex);
            }
            ++tabIndex;
        }
        tabIndex = tabFolder.getSelectionIndex();
        if (tabIndex == -1) {
            tabIndex = 0;
        }
        if ((tabItem = tabFolder.getItem(tabIndex)) != null) {
            Composite detailComposite = new Composite((Composite)tabItem.getParent(), 4);
            tabItem.setControl((Control)detailComposite);
            detailComposite.setLayout((Layout)new FillLayout());
            IDetailTab tab = (IDetailTab)tabItem.getData();
            tab.fillComposite(detailComposite);
            detailComposite.layout();
        }
        tabFolder.layout();
    }

    private static List createTabs(INode node) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Creating tabs for: " + node.getUniqueIdentifier()));
        }
        ArrayList<IDetailTab> tabList = new ArrayList<IDetailTab>();
        if (node instanceof DatabaseNode) {
            ConnectionInfoTab dbTab = new ConnectionInfoTab();
            dbTab.setNode(node);
            tabList.add(dbTab);
        }
        if (node instanceof TableNode) {
            ColumnInfoTab tab1 = new ColumnInfoTab();
            TableInfoTab tab2 = new TableInfoTab();
            PreviewTab tab3 = new PreviewTab();
            RowCountTab tab4 = new RowCountTab();
            PrimaryKeysTab tab5 = new PrimaryKeysTab();
            ExportedKeysTab tab6 = new ExportedKeysTab();
            ImportedKeysTab tab7 = new ImportedKeysTab();
            IndexesTab tab8 = new IndexesTab();
            PriviligesTab tab9 = new PriviligesTab();
            ColumnPriviligesTab tab10 = new ColumnPriviligesTab();
            RowIdsTab tab11 = new RowIdsTab();
            VersionsTab tab12 = new VersionsTab();
            tab1.setNode(node);
            tab2.setNode(node);
            tab3.setNode(node);
            tab4.setNode(node);
            tab5.setNode(node);
            tab6.setNode(node);
            tab7.setNode(node);
            tab8.setNode(node);
            tab9.setNode(node);
            tab10.setNode(node);
            tab11.setNode(node);
            tab12.setNode(node);
            tabList.add(tab1);
            tabList.add(tab2);
            tabList.add(tab3);
            tabList.add(tab4);
            tabList.add(tab5);
            tabList.add(tab6);
            tabList.add(tab7);
            tabList.add(tab8);
            tabList.add(tab9);
            tabList.add(tab10);
            tabList.add(tab11);
            tabList.add(tab12);
        }
        String databaseProductName = node.getSession().getRoot().getDatabaseProductName().toLowerCase().trim();
        String nodeType = node.getType().toLowerCase().trim();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("net.sourceforge.sqlexplorer", "nodeDetailTab");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension e = extensions[i];
            IConfigurationElement[] ces = e.getConfigurationElements();
            int j = 0;
            while (j < ces.length) {
                try {
                    String regex;
                    boolean isValidProduct = false;
                    boolean isValidNodeType = false;
                    String[] validProducts = ces[j].getAttribute("database-product-name").split(",");
                    String[] validNodeTypes = ces[j].getAttribute("node-type").split(",");
                    int k = 0;
                    while (k < validProducts.length) {
                        String product = validProducts[k].toLowerCase().trim();
                        if (product.length() != 0) {
                            if (product.equals("*")) {
                                isValidProduct = true;
                                break;
                            }
                            regex = TextUtil.replaceChar(product, '*', ".*");
                            if (databaseProductName.matches(regex)) {
                                isValidProduct = true;
                                break;
                            }
                        }
                        ++k;
                    }
                    if (isValidProduct) {
                        k = 0;
                        while (k < validNodeTypes.length) {
                            String type = validNodeTypes[k].toLowerCase().trim();
                            if (type.length() != 0) {
                                if (type.equals("*")) {
                                    isValidNodeType = true;
                                    break;
                                }
                                regex = TextUtil.replaceChar(type, '*', ".*");
                                if (nodeType.matches(regex)) {
                                    isValidNodeType = true;
                                    break;
                                }
                            }
                            ++k;
                        }
                        if (isValidNodeType) {
                            IDetailTab tab = (IDetailTab)ces[j].createExecutableExtension("class");
                            tab.setNode(node);
                            tabList.add(tab);
                        }
                    }
                }
                catch (Throwable ex) {
                    SQLExplorerPlugin.error("Could not create menu action", ex);
                }
                ++j;
            }
            ++i;
        }
        return tabList;
    }

    private static List getTabs(INode node) {
        List tabs;
        HashMap<String, List> tabCache;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Loading tabs for: " + node.getUniqueIdentifier()));
        }
        if ((tabCache = (HashMap<String, List>)_sessionTabCache.get(node.getSession())) == null) {
            tabCache = new HashMap<String, List>();
            _sessionTabCache.put(node.getSession(), tabCache);
        }
        if ((tabs = (List)tabCache.get(node.getUniqueIdentifier())) == null) {
            tabs = DetailTabManager.createTabs(node);
            tabCache.put(node.getUniqueIdentifier(), tabs);
        }
        if ((tabs == null || tabs.size() == 0) && node.getParent() != null) {
            return DetailTabManager.getTabs(node.getParent());
        }
        return tabs;
    }

    public static void setActiveTabName(String name) {
        _activeTabName = name;
    }
}

