/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbstructure;

import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.sqlexplorer.dbstructure.actions.AbstractDBTreeContextAction;
import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.views.DatabaseStructureView;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import net.sourceforge.sqlexplorer.util.TextUtil;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.actions.ActionGroup;

public class DBTreeActionGroup
extends ActionGroup {
    private TreeViewer _treeViewer;
    private DatabaseStructureView _view;

    public DBTreeActionGroup(TreeViewer treeViewer, DatabaseStructureView view) {
        this._treeViewer = treeViewer;
        this._view = view;
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this._treeViewer.getSelection();
        if (selection == null) {
            return;
        }
        ArrayList selectedNodes = new ArrayList();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (!(object instanceof INode)) continue;
            selectedNodes.add(object);
        }
        if (selectedNodes.size() == 0) {
            return;
        }
        INode[] nodes = selectedNodes.toArray(new INode[0]);
        IAction[] actions = this.getContextActions(nodes);
        int i = 0;
        while (i < actions.length) {
            menu.add(actions[i]);
            ++i;
        }
    }

    private IAction[] getContextActions(INode[] nodes) {
        String databaseProductName = nodes[0].getSession().getRoot().getDatabaseProductName().toLowerCase().trim();
        String nodeType = nodes[0].getType().toLowerCase().trim();
        ArrayList<AbstractDBTreeContextAction> actions = new ArrayList<AbstractDBTreeContextAction>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("net.sourceforge.sqlexplorer", "nodeContextAction");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension e = extensions[i];
            IConfigurationElement[] ces = e.getConfigurationElements();
            int j = 0;
            while (j < ces.length) {
                try {
                    String regex;
                    boolean isValidProduct = false;
                    boolean isValidNodeType = false;
                    String id = ces[j].getAttribute("id");
                    String[] validProducts = ces[j].getAttribute("database-product-name").split(",");
                    String[] validNodeTypes = ces[j].getAttribute("node-type").split(",");
                    String imagePath = ces[j].getAttribute("icon");
                    int k = 0;
                    while (k < validProducts.length) {
                        String product = validProducts[k].toLowerCase().trim();
                        if (product.length() != 0) {
                            if (product.equals("*")) {
                                isValidProduct = true;
                                break;
                            }
                            regex = TextUtil.replaceChar(product, '*', ".*");
                            if (databaseProductName.matches(regex)) {
                                isValidProduct = true;
                                break;
                            }
                        }
                        ++k;
                    }
                    if (isValidProduct) {
                        k = 0;
                        while (k < validNodeTypes.length) {
                            String type = validNodeTypes[k].toLowerCase().trim();
                            if (type.length() != 0) {
                                if (type.equals("*")) {
                                    isValidNodeType = true;
                                    break;
                                }
                                regex = TextUtil.replaceChar(type, '*', ".*");
                                if (nodeType.matches(regex)) {
                                    isValidNodeType = true;
                                    break;
                                }
                            }
                            ++k;
                        }
                        if (isValidNodeType) {
                            AbstractDBTreeContextAction action = (AbstractDBTreeContextAction)((Object)ces[j].createExecutableExtension("class"));
                            action.setSelectedNodes(nodes);
                            action.setTreeViewer(this._treeViewer);
                            action.setView(this._view);
                            String fragmentId = id.substring(0, id.indexOf(46, 28));
                            if (imagePath != null && imagePath.trim().length() != 0) {
                                action.setImageDescriptor(ImageUtil.getFragmentDescriptor(fragmentId, imagePath));
                            }
                            if (action.isAvailable()) {
                                actions.add(action);
                            }
                        }
                    }
                }
                catch (Throwable ex) {
                    SQLExplorerPlugin.error("Could not create menu action", ex);
                }
                ++j;
            }
            ++i;
        }
        return actions.toArray(new IAction[0]);
    }
}

