/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbstructure;

import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class DBTreeLabelProvider
extends LabelProvider {
    private Image _defaultNodeImage = ImageUtil.getImage("Images.DefaultNodeIcon");
    private Image _defaultParentNodeImage = ImageUtil.getImage("Images.DefaultParentNodeIcon");

    public void dispose() {
        super.dispose();
        ImageUtil.disposeImage("Images.DefaultNodeIcon");
        ImageUtil.disposeImage("Images.DefaultParentNodeIcon");
    }

    public Image getImage(Object element) {
        INode node = (INode)element;
        if (node.isExpanded() && node.getExpandedImage() != null && node.getChildNodes() != null && node.getChildNodes().length != 0) {
            return node.getExpandedImage();
        }
        if (node.getImage() != null) {
            return node.getImage();
        }
        if (node.hasChildNodes()) {
            return this._defaultParentNodeImage;
        }
        return this._defaultNodeImage;
    }

    public String getText(Object element) {
        INode node = (INode)element;
        String text = node.getLabelText();
        if (text == null) {
            text = node.toString();
        }
        if (node.getLabelDecoration() != null) {
            text = String.valueOf(text) + " [" + node.getLabelDecoration() + "]";
        }
        return text;
    }
}

