/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbstructure.nodes;

import net.sourceforge.sqlexplorer.SQLAlias;
import net.sourceforge.sqlexplorer.dbstructure.nodes.AbstractNode;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import net.sourceforge.sqlexplorer.util.TextUtil;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractFolderNode
extends AbstractNode {
    private String[] _filterExpressions;

    public AbstractFolderNode() {
        this._imageKey = "Images.closedFolder";
        this._expandedImageKey = "Images.OpenFolder";
    }

    public Image getImage() {
        if (this._imageKey == null) {
            return this._image;
        }
        return ImageUtil.getImage(this._imageKey);
    }

    public abstract String getName();

    public final String getUniqueIdentifier() {
        return String.valueOf(this.getParent().getName()) + '.' + this.getType();
    }

    protected boolean isExcludedByFilter(String name) {
        String filter;
        if (this._filterExpressions == null && (filter = ((SQLAlias)this.getSession().getAlias()).getNameFilterExpression()) != null) {
            this._filterExpressions = filter.split(",");
        }
        if (this._filterExpressions == null || this._filterExpressions.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this._filterExpressions.length) {
            String regex = this._filterExpressions[i].trim();
            regex = TextUtil.replaceChar(regex, '?', ".");
            if ((regex = TextUtil.replaceChar(regex, '*', ".*")).length() != 0 && name.matches(regex)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public abstract void loadChildren();
}

