/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbstructure.nodes;

import java.util.Comparator;
import java.util.Iterator;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbstructure.nodes.AbstractFolderNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.ColumnNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;

public class ColumnFolderNode
extends AbstractFolderNode {
    public ColumnFolderNode(INode parent, ITableInfo tableInfo) {
        this._sessionNode = parent.getSession();
        this._parent = parent;
        this._name = Messages.getString("DatabaseStructureView.node.Columns");
    }

    public Comparator getComparator() {
        return new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 == null || arg1 == null) {
                    return 0;
                }
                ColumnNode node1 = (ColumnNode)arg0;
                ColumnNode node2 = (ColumnNode)arg1;
                if (node1.isPrimaryKey() && !node2.isPrimaryKey()) {
                    return -1;
                }
                if (!node1.isPrimaryKey() && node2.isPrimaryKey()) {
                    return 1;
                }
                if (node1.isForeignKey() && !node2.isForeignKey()) {
                    return -1;
                }
                if (!node1.isForeignKey() && node2.isForeignKey()) {
                    return 1;
                }
                return node1.getName().compareTo(node2.getName());
            }
        };
    }

    public String getName() {
        return this._name;
    }

    public String getQualifiedName() {
        return String.valueOf(this.getParent().getQualifiedName()) + "." + this.getType();
    }

    public String getType() {
        return "column_folder";
    }

    public void loadChildren() {
        try {
            Iterator it = ((TableNode)this._parent).getColumnNames().iterator();
            while (it.hasNext()) {
                this.addChildNode(new ColumnNode(this, (String)it.next(), this._sessionNode, (TableNode)this._parent, true));
            }
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Could not create child nodes for " + this.getName(), e);
        }
    }
}

