/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbstructure.nodes;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbstructure.nodes.AbstractFolderNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.CatalogNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.SchemaNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;

public class TableFolderNode
extends AbstractFolderNode {
    private ITableInfo[] _allTables;
    private String _origName;

    public TableFolderNode(INode parent, String name, SessionTreeNode sessionNode, ITableInfo[] tables) {
        this._allTables = tables;
        this._sessionNode = sessionNode;
        this._parent = parent;
        this._origName = name;
        String[] words = this._origName.split(" ");
        this._name = "";
        int i = 0;
        while (i < words.length) {
            this._name = String.valueOf(this._name) + words[i].substring(0, 1).toUpperCase() + words[i].substring(1).toLowerCase() + " ";
            ++i;
        }
        this._name = this._name.trim();
        if (this._name.equals("View")) {
            this._name = Messages.getString("DatabaseStructureView.view");
        }
        if (this._name.equals("Table")) {
            this._name = Messages.getString("DatabaseStructureView.table");
        }
    }

    public String getName() {
        return this._name;
    }

    public String getQualifiedName() {
        return this._origName;
    }

    public String getType() {
        return String.valueOf(this._origName) + "_FOLDER";
    }

    public void loadChildren() {
        try {
            ITableInfo[] tables = null;
            if (this._allTables != null && this._allTables.length != 0) {
                tables = (ITableInfo[])this._allTables.clone();
                this._allTables = null;
            } else {
                String catalogName = null;
                String schemaName = null;
                if (this._parent instanceof CatalogNode) {
                    catalogName = this._parent.toString();
                    if (!this._parent.hasChildNodes()) {
                        catalogName = null;
                    }
                }
                if (this._parent instanceof SchemaNode) {
                    schemaName = this._parent.toString();
                }
                tables = this._sessionNode.getMetaData().getTables(catalogName, schemaName, "%", new String[]{this._origName});
            }
            int i = 0;
            while (i < tables.length) {
                if (tables[i].getType().equalsIgnoreCase(this._origName) && !this.isExcludedByFilter(tables[i].getSimpleName())) {
                    this.addChildNode(new TableNode(this, tables[i].getSimpleName(), this._sessionNode, tables[i]));
                }
                ++i;
            }
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Could not load child nodes for " + this._name, e);
        }
    }
}

