/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbstructure.nodes;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.sqlexplorer.dbstructure.nodes.AbstractNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.ColumnFolderNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.IndexFolderNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import net.sourceforge.sqlexplorer.util.TextUtil;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class TableNode
extends AbstractNode {
    private List _columnNames;
    private List _foreignKeyNames;
    private List _primaryKeyNames;
    private ITableInfo _tableInfo;
    private List _folderNames = new ArrayList();

    public TableNode(INode parent, String name, SessionTreeNode sessionNode, ITableInfo tableInfo) {
        this._tableInfo = tableInfo;
        this._sessionNode = sessionNode;
        this._parent = parent;
        this._name = name;
        this._imageKey = "Images.TableNodeIcon";
    }

    private void addExtensionNodes() {
        String databaseProductName = this.getSession().getRoot().getDatabaseProductName().toLowerCase().trim();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("net.sourceforge.sqlexplorer", "node");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension e = extensions[i];
            IConfigurationElement[] ces = e.getConfigurationElements();
            int j = 0;
            while (j < ces.length) {
                try {
                    String parent = ces[j].getAttribute("parent-node");
                    if (parent.indexOf("table") != -1) {
                        boolean isValidProduct = false;
                        String[] validProducts = ces[j].getAttribute("database-product-name").split(",");
                        int k = 0;
                        while (k < validProducts.length) {
                            String product = validProducts[k].toLowerCase().trim();
                            if (product.length() != 0) {
                                if (product.equals("*")) {
                                    isValidProduct = true;
                                    break;
                                }
                                String regex = TextUtil.replaceChar(product, '*', ".*");
                                if (databaseProductName.matches(regex)) {
                                    isValidProduct = true;
                                    break;
                                }
                            }
                            ++k;
                        }
                        if (isValidProduct) {
                            AbstractNode childNode = (AbstractNode)ces[j].createExecutableExtension("class");
                            String imagePath = ces[j].getAttribute("icon");
                            String id = ces[j].getAttribute("id");
                            String fragmentId = id.substring(0, id.indexOf(46, 28));
                            if (imagePath != null && imagePath.trim().length() != 0) {
                                childNode.setImage(ImageUtil.getFragmentImage(fragmentId, imagePath));
                            }
                            childNode.setParent(this);
                            childNode.setSession(this._sessionNode);
                            this.addChildNode(childNode);
                            this._folderNames.add(childNode.getName());
                        }
                    }
                }
                catch (Throwable ex) {
                    SQLExplorerPlugin.error("Could not create child node", ex);
                }
                ++j;
            }
            ++i;
        }
    }

    public List getColumnNames() {
        if (this._columnNames == null) {
            this._columnNames = new ArrayList();
            try {
                ResultSet resultSet = this._sessionNode.getMetaData().getColumns(this._tableInfo);
                while (resultSet.next()) {
                    this._columnNames.add(resultSet.getString(4));
                }
            }
            catch (Exception e) {
                SQLExplorerPlugin.error("Could not load column names", e);
            }
        }
        return this._columnNames;
    }

    public List getForeignKeyNames() {
        if (this._foreignKeyNames == null) {
            this._foreignKeyNames = new ArrayList();
            try {
                ResultSet resultSet = this._sessionNode.getMetaData().getImportedKeys(this._tableInfo);
                while (resultSet.next()) {
                    this._foreignKeyNames.add(resultSet.getString(4));
                }
            }
            catch (Exception e) {
                SQLExplorerPlugin.error("Could not load foreign key names", e);
            }
        }
        return this._foreignKeyNames;
    }

    public List getPrimaryKeyNames() {
        if (this._primaryKeyNames == null) {
            this._primaryKeyNames = new ArrayList();
            try {
                ResultSet resultSet = this._sessionNode.getMetaData().getPrimaryKeys(this._tableInfo);
                while (resultSet.next()) {
                    this._primaryKeyNames.add(resultSet.getString(4));
                }
            }
            catch (Exception e) {
                SQLExplorerPlugin.error("Could not load primary key names", e);
            }
        }
        return this._primaryKeyNames;
    }

    public String getQualifiedName() {
        return this._tableInfo.getQualifiedName();
    }

    public String getTableDesc() {
        return this.getTableInfo().getQualifiedName();
    }

    public ITableInfo getTableInfo() {
        return this._tableInfo;
    }

    public String getType() {
        return this._tableInfo.getType();
    }

    public String getUniqueIdentifier() {
        return this.getQualifiedName();
    }

    public boolean isEndNode() {
        return false;
    }

    public boolean isSynonym() {
        return this._tableInfo.getType().equalsIgnoreCase("SYNONYM");
    }

    public boolean isTable() {
        return this._tableInfo.getType().equalsIgnoreCase("TABLE");
    }

    public boolean isView() {
        return this._tableInfo.getType().equalsIgnoreCase("VIEW");
    }

    public void loadChildren() {
        try {
            IndexFolderNode indexNode;
            this.addExtensionNodes();
            ColumnFolderNode colNode = new ColumnFolderNode(this, this._tableInfo);
            if (!this._folderNames.contains(colNode.getName())) {
                this.addChildNode(colNode);
            }
            if (!this._folderNames.contains((indexNode = new IndexFolderNode(this, this._tableInfo)).getName())) {
                this.addChildNode(indexNode);
            }
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Could not create child nodes for " + this.getName(), e);
        }
    }
}

