/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dialogs;

import java.util.ArrayList;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbstructure.nodes.CatalogNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.DatabaseNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.SchemaNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.views.DatabaseStructureView;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FilterStructureDialog
extends Dialog {
    private DatabaseNode _db;
    private Text _filterText;
    private String[] _folderFilter;
    private Table _folderTable;
    private String _nameFilter;
    private Button _patternButton;
    private String[] _schemaFilter;
    private Table _schemaTable;

    public FilterStructureDialog(DatabaseStructureView view) {
        super(view.getSite().getShell());
        this._db = view.getActiveDatabase().getRoot();
    }

    public boolean close() {
        ArrayList<String> schemaSelection = new ArrayList<String>();
        TableItem[] items = this._schemaTable.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                if (items[i].getChecked()) {
                    schemaSelection.add(items[i].getText());
                }
                ++i;
            }
        }
        this._schemaFilter = schemaSelection.size() != 0 ? schemaSelection.toArray(new String[0]) : null;
        ArrayList<String> folderSelection = new ArrayList<String>();
        items = this._folderTable.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                if (items[i].getChecked()) {
                    folderSelection.add(items[i].getText());
                }
                ++i;
            }
        }
        this._folderFilter = folderSelection.size() != 0 ? folderSelection.toArray(new String[0]) : null;
        this._nameFilter = this._patternButton.getSelection() && this._filterText.getText() != null && this._filterText.getText().trim().length() != 0 ? this._filterText.getText().trim() : null;
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String title = String.valueOf(Messages.getString("FilterStructureDialog.Title.prefix")) + " " + this._db.getSession().toString() + " " + Messages.getString("FilterStructureDialog.Title.postfix");
        shell.setText(title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        final Composite composite = (Composite)super.createDialogArea(parent);
        try {
            Text pattern;
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginLeft = 10;
            layout.marginRight = 15;
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 5;
            layout.marginWidth = 0;
            layout.marginHeight = 5;
            GridData gridData = new GridData(1808);
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)gridData);
            GridData tGridData = new GridData(768);
            tGridData.horizontalSpan = 2;
            tGridData.horizontalAlignment = 4;
            tGridData.widthHint = 280;
            GridData t2GridData = new GridData(768);
            t2GridData.horizontalSpan = 2;
            t2GridData.horizontalAlignment = 4;
            t2GridData.verticalIndent = 15;
            GridData bData = new GridData();
            bData.horizontalIndent = 10;
            Label selectSchemaLabel = new Label(composite, 64);
            selectSchemaLabel.setLayoutData((Object)tGridData);
            selectSchemaLabel.setText(Messages.getString("FilterStructureDialog.SelectSchema"));
            final TableViewer schemaTable = new TableViewer(composite, 2592);
            this._schemaTable = schemaTable.getTable();
            GridData tableGridData = new GridData();
            tableGridData.horizontalSpan = 2;
            tableGridData.horizontalAlignment = 4;
            tableGridData.heightHint = 50;
            tableGridData.grabExcessHorizontalSpace = true;
            schemaTable.getControl().setLayoutData((Object)tableGridData);
            schemaTable.setContentProvider((IContentProvider)new TableContentProvider());
            schemaTable.setInput((Object)this._db);
            TableItem[] items = this._schemaTable.getItems();
            if (this._schemaFilter != null && items != null) {
                int i = 0;
                while (i < items.length) {
                    int j = 0;
                    while (j < this._schemaFilter.length) {
                        if (this._schemaFilter[j].equalsIgnoreCase(items[i].getText())) {
                            items[i].setChecked(true);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            Button selectAllSchemas = new Button(composite, 8);
            selectAllSchemas.setLayoutData((Object)bData);
            selectAllSchemas.setText(Messages.getString("FilterStructureDialog.Buttons.SelectAll"));
            selectAllSchemas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    Table table = schemaTable.getTable();
                    TableItem[] items = table.getItems();
                    if (items == null) {
                        return;
                    }
                    int i = 0;
                    while (i < items.length) {
                        items[i].setChecked(true);
                        ++i;
                    }
                }
            });
            Button deselectAllSchemas = new Button(composite, 8);
            deselectAllSchemas.setText(Messages.getString("FilterStructureDialog.Buttons.DeselectAll"));
            deselectAllSchemas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    Table table = schemaTable.getTable();
                    TableItem[] items = table.getItems();
                    if (items == null) {
                        return;
                    }
                    int i = 0;
                    while (i < items.length) {
                        items[i].setChecked(false);
                        ++i;
                    }
                }
            });
            Label selectFolderLabel = new Label(composite, 64);
            selectFolderLabel.setLayoutData((Object)t2GridData);
            selectFolderLabel.setText(Messages.getString("FilterStructureDialog.SelectFolder"));
            final TableViewer folderTable = new TableViewer(composite, 2592);
            this._folderTable = folderTable.getTable();
            folderTable.getControl().setLayoutData((Object)tableGridData);
            folderTable.setContentProvider((IContentProvider)new TableContentProvider());
            if (this._db.getChildNodes() != null && this._db.getChildNodes().length != 0) {
                folderTable.setInput((Object)this._db.getChildNodes()[0]);
            }
            items = this._folderTable.getItems();
            if (this._folderFilter != null && items != null) {
                int i = 0;
                while (i < items.length) {
                    int j = 0;
                    while (j < this._folderFilter.length) {
                        if (this._folderFilter[j].equalsIgnoreCase(items[i].getText())) {
                            items[i].setChecked(true);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            Button selectAllFolders = new Button(composite, 8);
            selectAllFolders.setLayoutData((Object)bData);
            selectAllFolders.setText(Messages.getString("FilterStructureDialog.Buttons.SelectAll"));
            selectAllFolders.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    Table table = folderTable.getTable();
                    TableItem[] items = table.getItems();
                    if (items == null) {
                        return;
                    }
                    int i = 0;
                    while (i < items.length) {
                        items[i].setChecked(true);
                        ++i;
                    }
                }
            });
            Button deselectAllFolders = new Button(composite, 8);
            deselectAllFolders.setText(Messages.getString("FilterStructureDialog.Buttons.DeselectAll"));
            deselectAllFolders.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    Table table = folderTable.getTable();
                    TableItem[] items = table.getItems();
                    if (items == null) {
                        return;
                    }
                    int i = 0;
                    while (i < items.length) {
                        items[i].setChecked(false);
                        ++i;
                    }
                }
            });
            this._patternButton = new Button(composite, 96);
            this._patternButton.setLayoutData((Object)t2GridData);
            this._patternButton.setText(Messages.getString("FilterStructureDialog.ElementPattern"));
            this._filterText = pattern = new Text(composite, 2048);
            GridData textData = new GridData(768);
            textData.horizontalSpan = 2;
            pattern.setLayoutData((Object)textData);
            pattern.setEnabled(this._patternButton.getSelection());
            if (this._nameFilter != null) {
                this._patternButton.setSelection(true);
                pattern.setEnabled(true);
                pattern.setText(this._nameFilter);
            } else {
                this._patternButton.setSelection(false);
            }
            final Label filterHelpLabel = new Label(composite, 64);
            GridData helpData = new GridData(768);
            helpData.horizontalSpan = 2;
            filterHelpLabel.setLayoutData((Object)helpData);
            filterHelpLabel.setText(Messages.getString("FilterStructureDialog.ElementPattern.help"));
            filterHelpLabel.setEnabled(this._patternButton.getSelection());
            this._patternButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    pattern.setEnabled(((Button)e.widget).getSelection());
                    filterHelpLabel.setEnabled(((Button)e.widget).getSelection());
                }
            });
            composite.addListener(16, new Listener(){

                public void handleEvent(Event event) {
                    composite.layout();
                    composite.redraw();
                }
            });
            return composite;
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Couldn't create dialog.", e);
            return null;
        }
    }

    public String[] getFolderFilter() {
        return this._folderFilter;
    }

    protected Point getInitialSize() {
        return new Point(300, 440);
    }

    public String getNameFilter() {
        return this._nameFilter;
    }

    public String[] getSchemaFilter() {
        return this._schemaFilter;
    }

    public void setFolderFilter(String[] folderFilter) {
        this._folderFilter = folderFilter;
    }

    public void setNameFilter(String nameFilter) {
        this._nameFilter = nameFilter;
    }

    public void setSchemaFilter(String[] schemaFilter) {
        this._schemaFilter = schemaFilter;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof DatabaseNode) {
                return ((DatabaseNode)input).getChildNames();
            }
            if (input instanceof SchemaNode) {
                return ((SchemaNode)input).getChildNames();
            }
            if (input instanceof CatalogNode) {
                return ((CatalogNode)input).getChildNames();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

