/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.history;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.sqlexplorer.ApplicationFiles;
import net.sourceforge.sqlexplorer.history.SQLHistoryChangedListener;
import net.sourceforge.sqlexplorer.history.SQLHistoryElement;
import net.sourceforge.sqlexplorer.history.SQLHistorySorter;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import org.eclipse.core.runtime.ListenerList;

public class SQLHistory {
    private List _filteredHistory = new ArrayList();
    private List _history = new ArrayList();
    private ListenerList _listeners = new ListenerList();
    private String _qry = null;
    private SQLHistorySorter _sorter = new SQLHistorySorter();
    private static final String EXECUTION_HINT_MARKER = "#EH#";
    private static final String NEWLINE_REPLACEMENT = "#LF#";
    private static final String NEWLINE_SEPARATOR = System.getProperty("line.separator");
    private static final String TAB_REPLACEMENT = "#T#";
    private static final String TAB_SEPARATOR = "\\t";
    private static final String SESSION_HINT_MARKER = "#SH#";
    private static final String TIME_HINT_MARKER = "#TH#";
    private int _autoSaveAfterCount = SQLExplorerPlugin.getDefault().getPluginPreferences().getInt("SQLHistory.AutoSaveAfterXXStatements");
    private int _queriesAdded = 0;

    public SQLHistory() {
        this.loadFromFile();
        this._qry = null;
    }

    public void addListener(SQLHistoryChangedListener listener) {
        this._listeners.add((Object)listener);
    }

    public void addSQL(String rawSqlString, String sessionName) {
        if (rawSqlString == null || rawSqlString.equalsIgnoreCase("commit") || rawSqlString.trim().length() == 0) {
            return;
        }
        int i = 0;
        while (i < this._history.size()) {
            SQLHistoryElement el = (SQLHistoryElement)this._history.get(i);
            if (el.equals(rawSqlString)) {
                this._history.remove(i);
                el.setSessionName(sessionName);
                el.increaseExecutionCount();
                this._history.add(0, el);
                this.refreshHistoryView();
                return;
            }
            ++i;
        }
        this._history.add(0, new SQLHistoryElement(rawSqlString, sessionName));
        this.refreshHistoryView();
        ++this._queriesAdded;
        this.checkAutoSave();
    }

    private void checkAutoSave() {
        if (this._autoSaveAfterCount > 0 && this._queriesAdded >= this._autoSaveAfterCount) {
            this._queriesAdded = 0;
            this.save();
        }
    }

    public void clear() {
        this._history.clear();
        this.refreshHistoryView();
    }

    public int getEntryCount() {
        if (this._qry == null) {
            return this._history.size();
        }
        return this._filteredHistory.size();
    }

    private void loadFromFile() {
        try {
            File file = new File(ApplicationFiles.SQLHISTORY_FILE_NAME);
            if (!file.exists()) {
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String currentLine = reader.readLine();
            while (currentLine != null) {
                if (currentLine.trim().length() != 0) {
                    String sessionHint = null;
                    String query = null;
                    String time = null;
                    String executions = null;
                    int pos = currentLine.indexOf(SESSION_HINT_MARKER);
                    if (pos != -1) {
                        sessionHint = currentLine.substring(0, pos);
                        int posT = (currentLine = currentLine.substring(pos + SESSION_HINT_MARKER.length())).indexOf(TIME_HINT_MARKER);
                        if (posT != -1) {
                            query = currentLine.substring(0, posT);
                            currentLine = currentLine.substring(posT + TIME_HINT_MARKER.length());
                            int posE = currentLine.indexOf(EXECUTION_HINT_MARKER);
                            time = currentLine.substring(0, posE);
                            executions = currentLine.substring(posE + EXECUTION_HINT_MARKER.length());
                        } else {
                            query = currentLine;
                        }
                        query = query.replaceAll(NEWLINE_REPLACEMENT, NEWLINE_SEPARATOR);
                        query = query.replaceAll(TAB_REPLACEMENT, " ");
                    }
                    if (query != null && query.trim().length() != 0) {
                        this._history.add(new SQLHistoryElement(query, sessionHint, time, executions));
                    }
                }
                currentLine = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Couldn't load sql history.", e);
        }
    }

    public void refreshHistoryView() {
        this.filter();
        Object[] ls = this._listeners.getListeners();
        int i = 0;
        while (i < ls.length) {
            try {
                ((SQLHistoryChangedListener)ls[i]).changed();
            }
            catch (Throwable throwable) {}
            ++i;
        }
    }

    public void remove(SQLHistoryElement element) {
        this._history.remove(element);
        this.refreshHistoryView();
    }

    public void removeListener(SQLHistoryChangedListener listener) {
        this._listeners.remove((Object)listener);
    }

    public void save() {
        try {
            File file = new File(ApplicationFiles.SQLHISTORY_FILE_NAME);
            if (file.exists()) {
                file.delete();
            }
            if (this._history.size() == 0) {
                return;
            }
            file.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            Iterator it = this._history.iterator();
            while (it.hasNext()) {
                SQLHistoryElement el = (SQLHistoryElement)it.next();
                String qry = el.getRawSQLString();
                qry = qry.replaceAll(NEWLINE_SEPARATOR, NEWLINE_REPLACEMENT);
                qry = qry.replaceAll(TAB_SEPARATOR, TAB_REPLACEMENT);
                String sessionHint = el.getSessionName();
                String tmpLine = String.valueOf(sessionHint) + SESSION_HINT_MARKER + qry + TIME_HINT_MARKER + el.getTime() + EXECUTION_HINT_MARKER + el.getExecutionCount();
                writer.write(tmpLine, 0, tmpLine.length());
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Couldn't save sql history.", e);
        }
    }

    public int setQryString(String qry) {
        this._qry = qry.trim().toLowerCase();
        if (this._qry != null && this._qry.trim().length() == 0) {
            this._qry = null;
        }
        this.refreshHistoryView();
        if (this._qry == null) {
            return this._history.size();
        }
        return this._filteredHistory.size();
    }

    private void filter() {
        if (this._qry == null || this._qry.trim().length() == 0) {
            this._qry = null;
            return;
        }
        this._filteredHistory = new ArrayList();
        String[] keyword = this._qry.split(" ");
        Iterator it = this._history.iterator();
        while (it.hasNext()) {
            SQLHistoryElement el = (SQLHistoryElement)it.next();
            boolean include = true;
            int i = 0;
            while (i < keyword.length) {
                if (el.getSearchableString().indexOf(keyword[i]) == -1) {
                    include = false;
                    break;
                }
                ++i;
            }
            if (!include) continue;
            this._filteredHistory.add(el);
        }
    }

    public void sort(int column, int direction) {
        this._sorter.setSortColumn(column, direction);
        Collections.sort(this._history, this._sorter);
        Collections.sort(this._filteredHistory, this._sorter);
    }

    public Object[] toArray() {
        if (this._qry == null) {
            return this._history.toArray();
        }
        return this._filteredHistory.toArray();
    }
}

