/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.history.actions;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.history.SQLHistoryElement;
import net.sourceforge.sqlexplorer.history.actions.AbstractHistoryContextAction;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPage;

public class AppendToEditorAction
extends AbstractHistoryContextAction {
    private ImageDescriptor _imageOpenInEditor = ImageUtil.getDescriptor("Images.AppendToEditor");

    public ImageDescriptor getImageDescriptor() {
        return this._imageOpenInEditor;
    }

    public String getText() {
        return Messages.getString("SQLHistoryView.AppendToEditor");
    }

    public boolean isEnabled() {
        TableItem[] ti = this._table.getSelection();
        if (ti == null || ti.length == 0) {
            return false;
        }
        IWorkbenchPage page = SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            return false;
        }
        SQLEditor editorPart = (SQLEditor)page.getActiveEditor();
        return editorPart != null;
    }

    public void run() {
        try {
            TableItem[] ti = this._table.getSelection();
            if (ti == null || ti.length == 0) {
                return;
            }
            String queryDelimiter = SQLExplorerPlugin.getDefault().getPluginPreferences().getString("SQLEditor.QueryDelimiter");
            StringBuffer copiedText = new StringBuffer();
            int i = 0;
            while (i < ti.length) {
                SQLHistoryElement el = (SQLHistoryElement)ti[i].getData();
                copiedText.append(el.getRawSQLString());
                copiedText.append(queryDelimiter);
                if (ti.length > 1) {
                    copiedText.append("\n");
                }
                ++i;
            }
            IWorkbenchPage page = SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page == null) {
                return;
            }
            SQLEditor editorPart = (SQLEditor)page.getActiveEditor();
            editorPart.setText(String.valueOf(editorPart.getSQLToBeExecuted()) + "\n" + copiedText.toString());
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error creating sql editor", e);
        }
    }
}

