/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.history.actions;

import net.sourceforge.sqlexplorer.AliasModel;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.SQLAlias;
import net.sourceforge.sqlexplorer.history.SQLHistoryElement;
import net.sourceforge.sqlexplorer.history.actions.AbstractHistoryContextAction;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.actions.OpenPasswordConnectDialogAction;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditorInput;
import net.sourceforge.sqlexplorer.sessiontree.model.RootSessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class OpenInEditorAction
extends AbstractHistoryContextAction {
    private ImageDescriptor _imageOpenInEditor = ImageUtil.getDescriptor("Images.OpenSQLIcon");

    public ImageDescriptor getImageDescriptor() {
        return this._imageOpenInEditor;
    }

    public String getText() {
        return Messages.getString("SQLHistoryView.OpenInEditor");
    }

    public boolean isEnabled() {
        TableItem[] ti = this._table.getSelection();
        return ti != null && ti.length != 0;
    }

    public void run() {
        try {
            TableItem[] ti = this._table.getSelection();
            if (ti == null || ti.length == 0) {
                return;
            }
            String queryDelimiter = SQLExplorerPlugin.getDefault().getPluginPreferences().getString("SQLEditor.QueryDelimiter");
            StringBuffer copiedText = new StringBuffer();
            int i = 0;
            while (i < ti.length) {
                SQLHistoryElement el = (SQLHistoryElement)ti[i].getData();
                copiedText.append(el.getRawSQLString());
                if (ti.length > 0) {
                    copiedText.append(queryDelimiter);
                    copiedText.append("\n");
                }
                ++i;
            }
            SQLHistoryElement sqlHistoryElement = (SQLHistoryElement)ti[0].getData();
            SessionTreeNode querySession = null;
            if (sqlHistoryElement.getSessionName() != null) {
                boolean okToOpen;
                RootSessionTreeNode sessionRoot = SQLExplorerPlugin.getDefault().stm.getRoot();
                Object[] sessions = sessionRoot.getChildren();
                if (sessions != null) {
                    int i2 = 0;
                    while (i2 < sessions.length) {
                        SessionTreeNode session = (SessionTreeNode)sessions[i2];
                        if (session.toString().equalsIgnoreCase(sqlHistoryElement.getSessionName())) {
                            querySession = session;
                            break;
                        }
                        ++i2;
                    }
                }
                if (querySession == null && (okToOpen = MessageDialog.openConfirm((Shell)this._table.getShell(), (String)Messages.getString("SQLHistoryView.OpenInEditor.Confirm.Title"), (String)(String.valueOf(Messages.getString("SQLHistoryView.OpenInEditor.Confirm.Message.Prefix")) + " " + sqlHistoryElement.getSessionName() + Messages.getString("SQLHistoryView.OpenInEditor.Confirm.Message.Postfix"))))) {
                    AliasModel aliasModel = SQLExplorerPlugin.getDefault().getAliasModel();
                    SQLAlias al = (SQLAlias)aliasModel.getAliasByName(sqlHistoryElement.getSessionName());
                    if (al != null) {
                        OpenPasswordConnectDialogAction openDlgAction = new OpenPasswordConnectDialogAction(this._view.getSite(), al, SQLExplorerPlugin.getDefault().getDriverModel(), SQLExplorerPlugin.getDefault().getPreferenceStore(), SQLExplorerPlugin.getDefault().getSQLDriverManager());
                        openDlgAction.run();
                    }
                    if ((sessions = sessionRoot.getChildren()) != null) {
                        int i3 = 0;
                        while (i3 < sessions.length) {
                            SessionTreeNode session = (SessionTreeNode)sessions[i3];
                            if (session.toString().equalsIgnoreCase(sqlHistoryElement.getSessionName())) {
                                querySession = session;
                                break;
                            }
                            ++i3;
                        }
                    }
                }
            }
            SQLEditorInput input = new SQLEditorInput("SQL Editor (" + SQLExplorerPlugin.getDefault().getNextElement() + ").sql");
            input.setSessionNode(querySession);
            IWorkbenchPage page = SQLExplorerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page == null) {
                return;
            }
            SQLEditor editorPart = (SQLEditor)page.openEditor((IEditorInput)input, "net.sourceforge.sqlexplorer.plugin.editors.SQLEditor");
            editorPart.setText(copiedText.toString());
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error creating sql editor", e);
        }
    }
}

