/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.history.actions;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.history.SQLHistoryElement;
import net.sourceforge.sqlexplorer.history.actions.AbstractHistoryContextAction;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.TableItem;

public class RemoveFromHistoryAction
extends AbstractHistoryContextAction {
    private ImageDescriptor _imageRemove = ImageUtil.getDescriptor("Images.RemoveIcon");

    public ImageDescriptor getImageDescriptor() {
        return this._imageRemove;
    }

    public String getText() {
        return Messages.getString("SQLHistoryView.RemoveFromHistory");
    }

    public boolean isEnabled() {
        TableItem[] ti = this._table.getSelection();
        return ti != null && ti.length != 0;
    }

    public void run() {
        try {
            TableItem[] selections = this._table.getSelection();
            if (selections != null && selections.length != 0) {
                int i = 0;
                while (i < selections.length) {
                    SQLHistoryElement el = (SQLHistoryElement)selections[i].getData();
                    if (el != null) {
                        this._history.remove(el);
                    }
                    ++i;
                }
            }
            this._table.deselectAll();
            this.setEnabled(false);
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error removing item from clipboard", e);
        }
    }
}

