/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin.editors;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditorInput;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditorSessionListener;
import net.sourceforge.sqlexplorer.plugin.views.DatabaseStructureView;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeModel;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.utility.Dictionary;
import net.sourceforge.sqlexplorer.sqleditor.SQLTextViewer;
import net.sourceforge.sqlexplorer.sqleditor.actions.ExecSQLAction;
import net.sourceforge.sqlexplorer.sqleditor.actions.SQLEditorToolBar;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;

public class SQLEditor
extends TextEditor {
    private SQLEditorToolBar _editorToolBar;
    private Button _limitResults;
    private Text _maxResultField;
    SQLEditorSessionListener listener;
    private MouseClickListener mcl = new MouseClickListener();
    private IPartListener partListener;
    SessionTreeNode sessionTreeNode;
    public SQLTextViewer sqlTextViewer;
    StatusLineManager statusMgr;
    SessionTreeModel stm;
    IPreferenceStore store;
    public static final String[] SUPPORTED_FILETYPES = new String[]{"*.txt", "*.sql", "*.*"};
    private boolean _enableContentAssist;
    static /* synthetic */ Class class$0;

    public SQLEditor() {
        this.stm = SQLExplorerPlugin.getDefault().stm;
        this._enableContentAssist = SQLExplorerPlugin.getDefault().getPluginPreferences().getBoolean("SQLEditor.Assist");
        this.store = SQLExplorerPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(this.store);
    }

    public void clearText() {
        this.sqlTextViewer.clearText();
    }

    protected void createActions() {
        super.createActions();
        if (!this._enableContentAssist) {
            return;
        }
        Action action = new Action("Auto-Completion"){

            public void run() {
                SQLEditor.this.sqlTextViewer.showAssistance();
            }
        };
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
    }

    public void createPartControl(Composite parent) {
        Object adapter;
        super.createPartControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getSourceViewer().getTextWidget(), "net.sourceforge.sqlexplorer.SQLEditor");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Control");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = this.getAdapter(clazz)) instanceof StyledText) {
            StyledText text = (StyledText)adapter;
            text.setWordWrap(SQLExplorerPlugin.getDefault().getPluginPreferences().getBoolean("SQLEditor.AutoWrap"));
        }
    }

    protected ISourceViewer createSourceViewer(final Composite parent, IVerticalRuler ruler, int style) {
        Text maxResultText;
        Button limitResults;
        parent.setLayout((Layout)new FillLayout());
        final Composite myParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        myParent.setLayout((Layout)layout);
        this._editorToolBar = new SQLEditorToolBar(myParent, this);
        this.listener = new SQLEditorSessionListener(this);
        this.stm.addListener(this.listener);
        Composite div1 = new Composite(myParent, 0);
        GridData lgid = new GridData();
        lgid.grabExcessHorizontalSpace = true;
        lgid.horizontalAlignment = 4;
        lgid.heightHint = 1;
        lgid.verticalIndent = 1;
        div1.setLayoutData((Object)lgid);
        div1.setBackground(this.getSite().getShell().getDisplay().getSystemColor(18));
        GridData gid = new GridData();
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        Dictionary dictionary = null;
        if (this.sessionTreeNode != null && this._enableContentAssist) {
            dictionary = this.sessionTreeNode.getDictionary();
        }
        this.sqlTextViewer = new SQLTextViewer(myParent, style, this.store, dictionary, ruler);
        this.sqlTextViewer.getControl().setLayoutData((Object)gid);
        Composite div2 = new Composite(myParent, 0);
        lgid = new GridData();
        lgid.grabExcessHorizontalSpace = true;
        lgid.horizontalAlignment = 4;
        lgid.heightHint = 1;
        lgid.verticalIndent = 0;
        div2.setLayoutData((Object)lgid);
        div2.setBackground(this.getSite().getShell().getDisplay().getSystemColor(18));
        Composite statusBar = new Composite(myParent, 0);
        GridLayout statusBarLayout = new GridLayout();
        statusBarLayout.numColumns = 3;
        statusBarLayout.verticalSpacing = 0;
        statusBarLayout.marginHeight = 0;
        statusBarLayout.marginWidth = 0;
        statusBarLayout.marginTop = 0;
        statusBarLayout.marginBottom = 0;
        statusBarLayout.marginRight = 5;
        statusBarLayout.horizontalSpacing = 5;
        statusBarLayout.verticalSpacing = 0;
        statusBar.setLayout((Layout)statusBarLayout);
        GridData statusBarGridData = new GridData(4, 1024, true, false);
        statusBarGridData.verticalIndent = 0;
        statusBarGridData.horizontalIndent = 0;
        statusBar.setLayoutData((Object)statusBarGridData);
        this.statusMgr = new StatusLineManager();
        this.statusMgr.createControl(statusBar);
        GridData c1Grid = new GridData();
        c1Grid.horizontalAlignment = 4;
        c1Grid.verticalAlignment = 1024;
        c1Grid.grabExcessHorizontalSpace = true;
        c1Grid.grabExcessVerticalSpace = false;
        this.statusMgr.getControl().setLayoutData((Object)c1Grid);
        GridData c2Grid = new GridData();
        c2Grid.horizontalAlignment = 131072;
        c2Grid.verticalAlignment = 0x1000000;
        c2Grid.grabExcessHorizontalSpace = false;
        c2Grid.grabExcessVerticalSpace = false;
        this._limitResults = limitResults = new Button(statusBar, 32);
        limitResults.setText(Messages.getString("SQLEditor.LimitRows"));
        limitResults.setSelection(true);
        limitResults.setLayoutData((Object)c2Grid);
        GridData c3Grid = new GridData();
        c3Grid.horizontalAlignment = 131072;
        c3Grid.verticalAlignment = 0x1000000;
        c3Grid.grabExcessHorizontalSpace = false;
        c3Grid.grabExcessVerticalSpace = false;
        c3Grid.widthHint = 30;
        this._maxResultField = maxResultText = new Text(statusBar, 2052);
        maxResultText.setText(this.store.getString("SQLEditor.MaxSQLRows"));
        maxResultText.setLayoutData((Object)c3Grid);
        limitResults.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                maxResultText.setEnabled(limitResults.getSelection());
            }
        });
        final SQLEditor thisEditor = this;
        this.sqlTextViewer.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){
            private ExecSQLAction _execSQLAction = new ExecSQLAction();

            public void verifyKey(VerifyEvent event) {
                if (event.stateMask == 262144 && event.keyCode == 13) {
                    event.doit = false;
                    this._execSQLAction.setEditor(thisEditor);
                    this._execSQLAction.run();
                }
            }
        });
        this.sqlTextViewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                SQLEditor.this.getEditorSite().getPage().activate(SQLEditor.this.getEditorSite().getPart());
            }
        });
        statusBar.layout();
        myParent.layout();
        Document dc = new Document();
        this.sqlTextViewer.setDocument((IDocument)dc);
        this.mcl.install((ISourceViewer)this.sqlTextViewer);
        ControlListener resizeListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                myParent.layout(true);
                parent.layout(true);
            }
        };
        this._editorToolBar.addResizeListener(resizeListener);
        return this.sqlTextViewer;
    }

    public void dispose() {
        if (this.partListener != null) {
            this.getEditorSite().getPage().removePartListener(this.partListener);
        }
        this.stm.removeListener(this.listener);
        this.mcl.uninstall();
        super.dispose();
    }

    public void doSaveAs() {
        FileDialog dialog = new FileDialog(this.getSite().getShell(), 8192);
        dialog.setText(Messages.getString("SQLEditor.SaveAsDialog.Title"));
        dialog.setFilterExtensions(SUPPORTED_FILETYPES);
        dialog.setFilterNames(SUPPORTED_FILETYPES);
        dialog.setFileName("sql_editor.txt");
        String path = dialog.open();
        if (path == null) {
            return;
        }
        try {
            File file = new File(path);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            String content = this.sqlTextViewer.getDocument().get();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(content, 0, content.length());
            writer.close();
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Couldn't save sql history.", e);
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.getString("SQLEditor.SaveAsDialog.Error"), (String)e.getMessage());
        }
    }

    public SQLEditorToolBar getEditorToolBar() {
        return this._editorToolBar;
    }

    public Button getLimitResults() {
        return this._limitResults;
    }

    public Text getMaxResultField() {
        return this._maxResultField;
    }

    public SessionTreeNode getSessionTreeNode() {
        return this.sessionTreeNode;
    }

    public String getSQLToBeExecuted() {
        String sql = this.sqlTextViewer.getTextWidget().getSelectionText();
        if (sql == null || sql.trim().length() == 0) {
            sql = this.sqlTextViewer.getTextWidget().getText();
        }
        return sql != null ? sql : "";
    }

    ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (input instanceof SQLEditorInput) {
            SQLEditorInput sqlInput = (SQLEditorInput)input;
            this.sessionTreeNode = sqlInput.getSessionNode();
        }
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public void setMessage(String s) {
        this.statusMgr.setMessage(s);
    }

    public void setNewDictionary(final Dictionary dictionary) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (SQLEditor.this.sqlTextViewer != null) {
                    SQLEditor.this.sqlTextViewer.setNewDictionary(dictionary);
                    if (SQLEditor.this.sessionTreeNode != null) {
                        SQLEditor.this.sqlTextViewer.refresh();
                    }
                }
            }
        });
    }

    public void setSessionTreeNode(SessionTreeNode pSessionTreeNode) {
        this.sessionTreeNode = pSessionTreeNode;
        if (this.sessionTreeNode != null && this._enableContentAssist) {
            this.setNewDictionary(this.sessionTreeNode.getDictionary());
        } else {
            this.setNewDictionary(null);
        }
    }

    public void setText(String txt) {
        Document dc = new Document(txt);
        this.sqlTextViewer.setDocument((IDocument)dc);
        this.sqlTextViewer.refresh();
    }

    class MouseClickListener
    implements KeyListener,
    MouseListener,
    MouseMoveListener,
    FocusListener,
    PaintListener,
    IPropertyChangeListener,
    IDocumentListener,
    ITextInputListener {
        INode activeTableNode;
        private boolean fActive;
        private IRegion fActiveRegion;
        private Color fColor;
        private Cursor fCursor;
        private int fKeyModifierMask = 262144;
        private Position fRememberedPosition;
        private ISourceViewer sourceViewer;

        MouseClickListener() {
        }

        private void activateCursor(ISourceViewer viewer) {
            StyledText text = viewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            Display display = text.getDisplay();
            if (this.fCursor == null) {
                this.fCursor = new Cursor((Device)display, 21);
            }
            text.setCursor(this.fCursor);
        }

        public void deactivate() {
            this.deactivate(false);
        }

        public void deactivate(boolean redrawAll) {
            if (!this.fActive) {
                return;
            }
            this.repairRepresentation(redrawAll);
            this.fActive = false;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (this.fActive && this.fActiveRegion != null) {
                this.fRememberedPosition = new Position(this.fActiveRegion.getOffset(), this.fActiveRegion.getLength());
                try {
                    event.getDocument().addPosition(this.fRememberedPosition);
                }
                catch (BadLocationException badLocationException) {
                    this.fRememberedPosition = null;
                }
            }
        }

        public void documentChanged(DocumentEvent event) {
            StyledText widget;
            if (this.fRememberedPosition != null && !this.fRememberedPosition.isDeleted()) {
                event.getDocument().removePosition(this.fRememberedPosition);
                this.fActiveRegion = new Region(this.fRememberedPosition.getOffset(), this.fRememberedPosition.getLength());
            }
            this.fRememberedPosition = null;
            if (this.sourceViewer != null && (widget = this.sourceViewer.getTextWidget()) != null && !widget.isDisposed()) {
                widget.getDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ MouseClickListener this$1;
                    {
                        this.this$1 = mouseClickListener;
                    }

                    public void run() {
                        this.this$1.deactivate();
                    }
                });
            }
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            this.deactivate();
        }

        private int getCurrentTextOffset(ISourceViewer viewer) {
            StyledText text;
            block4: {
                try {
                    text = viewer.getTextWidget();
                    if (text != null && !text.isDisposed()) break block4;
                    return -1;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return -1;
                }
            }
            Display display = text.getDisplay();
            Point absolutePosition = display.getCursorLocation();
            Point relativePosition = text.toControl(absolutePosition);
            int widgetOffset = text.getOffsetAtLocation(relativePosition);
            if (viewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                return extension.widgetOffset2ModelOffset(widgetOffset);
            }
            return widgetOffset + viewer.getVisibleRegion().getOffset();
        }

        private IRegion getCurrentTextRegion(ISourceViewer viewer) {
            Object obj;
            IRegion reg;
            block16: {
                block15: {
                    block14: {
                        String selection;
                        Dictionary dictionary;
                        block13: {
                            block12: {
                                if (viewer == null) {
                                    return null;
                                }
                                dictionary = ((SQLTextViewer)viewer).dictionary;
                                if (dictionary == null) {
                                    return null;
                                }
                                int offset = this.getCurrentTextOffset(viewer);
                                if (offset == -1) {
                                    return null;
                                }
                                try {
                                    reg = this.selectWord(viewer.getDocument(), offset);
                                    if (reg != null) break block12;
                                    return null;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    return null;
                                }
                            }
                            selection = viewer.getDocument().get(reg.getOffset(), reg.getLength());
                            if (selection != null) break block13;
                            return null;
                        }
                        obj = dictionary.getByTableName(selection.toLowerCase());
                        if (obj != null) break block14;
                        return null;
                    }
                    if (obj instanceof ArrayList) break block15;
                    return null;
                }
                ArrayList ls = (ArrayList)obj;
                if (!ls.isEmpty()) break block16;
                return null;
            }
            Object node = ((ArrayList)obj).get(0);
            if (!(node instanceof TableNode)) {
                return null;
            }
            this.activeTableNode = (INode)node;
            return reg;
        }

        private Point getMaximumLocation(StyledText text, int offset, int length) {
            Point maxLocation = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
            int i = 0;
            while (i <= length) {
                Point location = text.getLocationAtOffset(offset + i);
                if (location.x > maxLocation.x) {
                    maxLocation.x = location.x;
                }
                if (location.y > maxLocation.y) {
                    maxLocation.y = location.y;
                }
                ++i;
            }
            return maxLocation;
        }

        private Point getMinimumLocation(StyledText text, int offset, int length) {
            Point minLocation = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
            int i = 0;
            while (i <= length) {
                Point location = text.getLocationAtOffset(offset + i);
                if (location.x < minLocation.x) {
                    minLocation.x = location.x;
                }
                if (location.y < minLocation.y) {
                    minLocation.y = location.y;
                }
                ++i;
            }
            return minLocation;
        }

        private void highlightRegion(ISourceViewer viewer, IRegion region) {
            if (region.equals(this.fActiveRegion)) {
                return;
            }
            this.repairRepresentation();
            StyledText text = viewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            int offset = 0;
            int length = 0;
            if (viewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                IRegion widgetRange = extension.modelRange2WidgetRange(region);
                if (widgetRange == null) {
                    return;
                }
                offset = widgetRange.getOffset();
                length = widgetRange.getLength();
            } else {
                offset = region.getOffset() - viewer.getVisibleRegion().getOffset();
                length = region.getLength();
            }
            StyleRange oldStyleRange = text.getStyleRangeAtOffset(offset);
            Color foregroundColor = this.fColor;
            Color backgroundColor = oldStyleRange == null ? text.getBackground() : oldStyleRange.background;
            StyleRange styleRange = new StyleRange(offset, length, foregroundColor, backgroundColor);
            text.setStyleRange(styleRange);
            text.redrawRange(offset, length, true);
            this.fActiveRegion = region;
        }

        private boolean includes(IRegion region, IRegion position) {
            return position.getOffset() >= region.getOffset() && position.getOffset() + position.getLength() <= region.getOffset() + region.getLength();
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == null) {
                return;
            }
            this.deactivate();
            oldInput.removeDocumentListener((IDocumentListener)this);
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput == null) {
                return;
            }
            newInput.addDocumentListener((IDocumentListener)this);
        }

        public void install(ISourceViewer sourceViewer) {
            this.sourceViewer = sourceViewer;
            if (sourceViewer == null) {
                return;
            }
            StyledText text = sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            this.updateColor(sourceViewer);
            sourceViewer.addTextInputListener((ITextInputListener)this);
            IDocument document = sourceViewer.getDocument();
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
            text.addKeyListener((KeyListener)this);
            text.addMouseListener((MouseListener)this);
            text.addMouseMoveListener((MouseMoveListener)this);
            text.addFocusListener((FocusListener)this);
            text.addPaintListener((PaintListener)this);
        }

        public void keyPressed(KeyEvent event) {
            if (this.fActive) {
                this.deactivate();
                return;
            }
            if (event.keyCode != this.fKeyModifierMask) {
                this.deactivate();
                return;
            }
            this.fActive = true;
        }

        public void keyReleased(KeyEvent e) {
            if (!this.fActive) {
                return;
            }
            this.deactivate();
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent event) {
            if (!this.fActive) {
                return;
            }
            if (event.stateMask != this.fKeyModifierMask) {
                this.deactivate();
                return;
            }
            if (event.button != 1) {
                this.deactivate();
                return;
            }
        }

        public void mouseMove(MouseEvent event) {
            if (event.widget instanceof Control && !((Control)event.widget).isFocusControl()) {
                this.deactivate();
                return;
            }
            if (!this.fActive) {
                if (event.stateMask != this.fKeyModifierMask) {
                    return;
                }
                this.fActive = true;
            }
            if (this.sourceViewer == null) {
                this.deactivate();
                return;
            }
            StyledText text = this.sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                this.deactivate();
                return;
            }
            if ((event.stateMask & 0x80000) != 0 && text.getSelectionCount() != 0) {
                this.deactivate();
                return;
            }
            IRegion region = this.getCurrentTextRegion(this.sourceViewer);
            if (region == null || region.getLength() == 0) {
                this.repairRepresentation();
                return;
            }
            this.highlightRegion(this.sourceViewer, region);
            this.activateCursor(this.sourceViewer);
        }

        public void mouseUp(MouseEvent e) {
            if (!this.fActive) {
                return;
            }
            if (e.button != 1) {
                this.deactivate();
                return;
            }
            boolean wasActive = this.fCursor != null;
            this.deactivate();
            if (wasActive) {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this){
                    final /* synthetic */ MouseClickListener this$1;
                    {
                        this.this$1 = mouseClickListener;
                    }

                    public void run() {
                        try {
                            DatabaseStructureView structureView = (DatabaseStructureView)MouseClickListener.access$0(this.this$1).getEditorSite().getWorkbenchWindow().getActivePage().findView("net.sourceforge.sqlexplorer.plugin.views.DatabaseStructureView");
                            if (structureView != null) {
                                MouseClickListener.access$0(this.this$1).getEditorSite().getWorkbenchWindow().getActivePage().bringToTop((IWorkbenchPart)structureView);
                            }
                        }
                        catch (Exception e1) {
                            SQLExplorerPlugin.error("Error selecting table", e1);
                        }
                    }
                });
            }
        }

        public void paintControl(PaintEvent event) {
            if (this.fActiveRegion == null) {
                return;
            }
            if (this.sourceViewer == null) {
                return;
            }
            StyledText text = this.sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            int offset = 0;
            int length = 0;
            if (this.sourceViewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)this.sourceViewer;
                IRegion widgetRange = extension.modelRange2WidgetRange((IRegion)new Region(offset, length));
                if (widgetRange == null) {
                    return;
                }
                offset = widgetRange.getOffset();
                length = widgetRange.getLength();
            } else {
                IRegion region = this.sourceViewer.getVisibleRegion();
                if (!this.includes(region, this.fActiveRegion)) {
                    return;
                }
                offset = this.fActiveRegion.getOffset() - region.getOffset();
                length = this.fActiveRegion.getLength();
            }
            Point minLocation = this.getMinimumLocation(text, offset, length);
            Point maxLocation = this.getMaximumLocation(text, offset, length);
            int x1 = minLocation.x;
            int x2 = minLocation.x + maxLocation.x - minLocation.x - 1;
            int y = minLocation.y + text.getLineHeight() - 1;
            GC gc = event.gc;
            if (this.fColor != null && !this.fColor.isDisposed()) {
                gc.setForeground(this.fColor);
            }
            gc.drawLine(x1, y, x2, y);
        }

        public void propertyChange(PropertyChangeEvent event) {
        }

        private void repairRepresentation() {
            this.repairRepresentation(false);
        }

        private void repairRepresentation(boolean redrawAll) {
            if (this.fActiveRegion == null) {
                return;
            }
            if (this.sourceViewer != null) {
                this.resetCursor(this.sourceViewer);
                int offset = this.fActiveRegion.getOffset();
                int length = this.fActiveRegion.getLength();
                if (!redrawAll && this.sourceViewer instanceof ITextViewerExtension2) {
                    ((ITextViewerExtension2)this.sourceViewer).invalidateTextPresentation(offset, length);
                } else {
                    this.sourceViewer.invalidateTextPresentation();
                }
                if (this.sourceViewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 extension = (ITextViewerExtension5)this.sourceViewer;
                    offset = extension.modelOffset2WidgetOffset(offset);
                } else {
                    offset -= this.sourceViewer.getVisibleRegion().getOffset();
                }
                StyledText text = this.sourceViewer.getTextWidget();
                try {
                    text.redrawRange(offset, length, true);
                }
                catch (IllegalArgumentException x) {
                    x.printStackTrace();
                }
            }
            this.fActiveRegion = null;
        }

        private void resetCursor(ISourceViewer viewer) {
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                text.setCursor(null);
            }
            if (this.fCursor != null) {
                this.fCursor.dispose();
                this.fCursor = null;
            }
        }

        private IRegion selectWord(IDocument document, int anchor) {
            try {
                char c;
                int offset = anchor;
                while (offset >= 0) {
                    c = document.getChar(offset);
                    if (!Character.isJavaIdentifierPart(c)) break;
                    --offset;
                }
                int start = offset;
                offset = anchor;
                int length = document.getLength();
                while (offset < length) {
                    c = document.getChar(offset);
                    if (!Character.isJavaIdentifierPart(c)) break;
                    ++offset;
                }
                int end = offset;
                if (start == end) {
                    return new Region(start, 0);
                }
                return new Region(start + 1, end - start - 1);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }

        public void uninstall() {
            StyledText text;
            if (this.fColor != null) {
                this.fColor.dispose();
                this.fColor = null;
            }
            if (this.fCursor != null) {
                this.fCursor.dispose();
                this.fCursor = null;
            }
            if (this.sourceViewer == null) {
                return;
            }
            this.sourceViewer.removeTextInputListener((ITextInputListener)this);
            IDocument document = this.sourceViewer.getDocument();
            if (document != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
            if ((text = this.sourceViewer.getTextWidget()) == null || text.isDisposed()) {
                return;
            }
            text.removeKeyListener((KeyListener)this);
            text.removeMouseListener((MouseListener)this);
            text.removeMouseMoveListener((MouseMoveListener)this);
            text.removeFocusListener((FocusListener)this);
            text.removePaintListener((PaintListener)this);
        }

        private void updateColor(ISourceViewer viewer) {
            StyledText text;
            if (this.fColor != null) {
                this.fColor.dispose();
            }
            if ((text = viewer.getTextWidget()) == null || text.isDisposed()) {
                return;
            }
            Display display = text.getDisplay();
            this.fColor = new Color((Device)display, new RGB(0, 0, 255));
        }

        static /* synthetic */ SQLEditor access$0(MouseClickListener mouseClickListener) {
            return mouseClickListener.SQLEditor.this;
        }
    }
}

