/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin.perspectives;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.sqlexplorer.plugin.views.SqlexplorerViewConstants;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class SQLExplorerPluginPerspective
implements IPerspectiveFactory {
    public void createInitialLayout(IPageLayout layout) {
        this.defineActions(layout);
        this.defineLayout(layout);
    }

    private void defineActions(IPageLayout layout) {
        List views = SqlexplorerViewConstants.getInstance().getFullViewList();
        Iterator iterator = views.iterator();
        while (iterator.hasNext()) {
            layout.addShowViewShortcut((String)iterator.next());
        }
    }

    private void defineLayout(IPageLayout layout) {
        layout.setEditorAreaVisible(true);
        String editorArea = layout.getEditorArea();
        IFolderLayout topLeft = layout.createFolder("topLeft", 1, 0.15f, editorArea);
        topLeft.addView("net.sourceforge.sqlexplorer.plugin.views.ConnectionsView");
        IFolderLayout bottomLeft = layout.createFolder("bottomLeft", 4, 0.3f, "topLeft");
        bottomLeft.addView("net.sourceforge.sqlexplorer.plugin.views.SQLHistoryView");
        IFolderLayout main = layout.createFolder("right", 2, 0.7f, editorArea);
        main.addView("net.sourceforge.sqlexplorer.plugin.views.DatabaseStructureView");
        IFolderLayout bottomRight = layout.createFolder("bottomRight", 4, 0.9f, "right");
        bottomRight.addView("org.eclipse.ui.views.ProgressView");
        IFolderLayout bottom = layout.createFolder("bottom", 4, 0.35f, editorArea);
        bottom.addView("net.sourceforge.sqlexplorer.plugin.views.SqlResultsView");
        bottom.addView("net.sourceforge.sqlexplorer.plugin.views.DatabaseDetailView");
    }
}

