/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin.views;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbstructure.DBTreeActionGroup;
import net.sourceforge.sqlexplorer.dbstructure.DBTreeContentProvider;
import net.sourceforge.sqlexplorer.dbstructure.DBTreeLabelProvider;
import net.sourceforge.sqlexplorer.dbstructure.DatabaseModel;
import net.sourceforge.sqlexplorer.dbstructure.actions.FilterStructureAction;
import net.sourceforge.sqlexplorer.dbstructure.nodes.ColumnNode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.INode;
import net.sourceforge.sqlexplorer.dbstructure.nodes.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.views.DatabaseDetailView;
import net.sourceforge.sqlexplorer.plugin.views.TableNodeTransfer;
import net.sourceforge.sqlexplorer.sessiontree.model.ISessionTreeClosedListener;
import net.sourceforge.sqlexplorer.sessiontree.model.RootSessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class DatabaseStructureView
extends ViewPart {
    private FilterStructureAction _filterAction;
    private Composite _parent;
    private TabFolder _tabFolder;
    private List _allSessions = new ArrayList();

    public void addSession(final SessionTreeNode sessionTreeNode) {
        if (this._allSessions.contains(sessionTreeNode)) {
            return;
        }
        this._allSessions.add(sessionTreeNode);
        if (this._filterAction != null) {
            this._filterAction.setEnabled(true);
        }
        if (this._tabFolder == null || this._tabFolder.isDisposed()) {
            this.clearParent();
            this._tabFolder = new TabFolder(this._parent, 0);
            this._tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseDetailView detailView = (DatabaseDetailView)DatabaseStructureView.this.getSite().getPage().findView("net.sourceforge.sqlexplorer.plugin.views.DatabaseDetailView");
                    DatabaseStructureView.this.synchronizeDetailView(detailView);
                }
            });
            this._parent.layout();
            this._parent.redraw();
        }
        final TabItem tabItem = new TabItem(this._tabFolder, 0);
        String labelText = sessionTreeNode.toString();
        tabItem.setText(labelText);
        Composite composite = new Composite((Composite)this._tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        tabItem.setControl((Control)composite);
        final TreeViewer treeViewer = new TreeViewer(composite, 2818);
        Transfer[] transfers = new Transfer[]{TableNodeTransfer.getInstance()};
        treeViewer.addDragSupport(1, transfers, new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
                System.out.println("$drag finished");
                TableNodeTransfer.getInstance().setSelection(null);
            }

            public void dragSetData(DragSourceEvent event) {
                Object sel;
                event.data = sel = ((IStructuredSelection)treeViewer.getSelection()).getFirstElement();
            }

            public void dragStart(DragSourceEvent event) {
                boolean bl = event.doit = !treeViewer.getSelection().isEmpty();
                if (event.doit) {
                    Object sel = ((IStructuredSelection)treeViewer.getSelection()).getFirstElement();
                    if (!(sel instanceof TableNode)) {
                        event.doit = false;
                    } else {
                        TableNode tn = (TableNode)sel;
                        TableNodeTransfer.getInstance().setSelection(tn);
                        if (!tn.isTable()) {
                            event.doit = false;
                        }
                    }
                }
            }
        });
        treeViewer.setUseHashlookup(true);
        treeViewer.setContentProvider((IContentProvider)new DBTreeContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new DBTreeLabelProvider());
        treeViewer.setInput((Object)sessionTreeNode.dbModel);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent ev) {
                DatabaseDetailView detailView = (DatabaseDetailView)DatabaseStructureView.this.getSite().getPage().findView("net.sourceforge.sqlexplorer.plugin.views.DatabaseDetailView");
                DatabaseStructureView.this.synchronizeDetailView(detailView);
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                try {
                    DatabaseDetailView detailView = (DatabaseDetailView)DatabaseStructureView.this.getSite().getPage().findView("net.sourceforge.sqlexplorer.plugin.views.DatabaseDetailView");
                    if (detailView == null) {
                        DatabaseStructureView.this.getSite().getPage().showView("net.sourceforge.sqlexplorer.plugin.views.DatabaseDetailView");
                    }
                    DatabaseStructureView.this.getSite().getPage().bringToTop((IWorkbenchPart)detailView);
                    DatabaseStructureView.this.synchronizeDetailView(detailView);
                }
                catch (Exception exception) {}
            }
        });
        tabItem.setData((Object)treeViewer);
        sessionTreeNode.addListener(new ISessionTreeClosedListener(){

            public void sessionTreeClosed() {
                if (tabItem.getParent().getItemCount() == 1) {
                    DatabaseDetailView detailView = (DatabaseDetailView)DatabaseStructureView.this.getSite().getPage().findView("net.sourceforge.sqlexplorer.plugin.views.DatabaseDetailView");
                    if (detailView != null) {
                        detailView.setSelectedNode(null);
                    }
                    DatabaseStructureView.this.setDefaultMessage();
                    DatabaseStructureView.this._filterAction.setEnabled(false);
                } else {
                    tabItem.setData(null);
                    tabItem.dispose();
                }
                DatabaseStructureView.this._allSessions.remove(sessionTreeNode);
            }
        });
        treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                INode node = (INode)event.getElement();
                node.setExpanded(false);
                TreeViewer viewer = (TreeViewer)event.getSource();
                viewer.update((Object)node, null);
            }

            public void treeExpanded(TreeExpansionEvent event) {
                INode node = (INode)event.getElement();
                node.setExpanded(true);
                TreeViewer viewer = (TreeViewer)event.getSource();
                viewer.update((Object)node, null);
            }
        });
        this._tabFolder.setSelection(this._tabFolder.getItemCount() - 1);
        DatabaseDetailView detailView = (DatabaseDetailView)this.getSite().getPage().findView("net.sourceforge.sqlexplorer.plugin.views.DatabaseDetailView");
        if (detailView != null) {
            this.synchronizeDetailView(detailView);
            this.getSite().getPage().bringToTop((IWorkbenchPart)detailView);
        }
        composite.layout();
        this._tabFolder.layout();
        this._tabFolder.redraw();
        this.getSite().getPage().bringToTop((IWorkbenchPart)this);
        final DBTreeActionGroup actionGroup = new DBTreeActionGroup(treeViewer, this);
        MenuManager menuManager = new MenuManager("DBTreeContextMenu");
        menuManager.setRemoveAllWhenShown(true);
        Menu contextMenu = menuManager.createContextMenu((Control)treeViewer.getTree());
        treeViewer.getTree().setMenu(contextMenu);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                actionGroup.fillContextMenu(manager);
            }
        });
    }

    private void clearParent() {
        Control[] children = this._parent.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
    }

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "net.sourceforge.sqlexplorer.DatabaseStructureView");
        this._parent = parent;
        RootSessionTreeNode sessionRoot = SQLExplorerPlugin.getDefault().stm.getRoot();
        Object[] sessions = sessionRoot.getChildren();
        if (sessions != null) {
            int i = 0;
            while (i < sessions.length) {
                SessionTreeNode session = (SessionTreeNode)sessions[i];
                this.addSession(session);
                ++i;
            }
        }
        if (sessions == null || sessions.length == 0) {
            this.setDefaultMessage();
        }
        this._filterAction = new FilterStructureAction(this);
        this._filterAction.setEnabled(sessions != null && sessions.length != 0);
        IToolBarManager toolBarMgr = this.getViewSite().getActionBars().getToolBarManager();
        toolBarMgr.add((IAction)this._filterAction);
    }

    public void dispose() {
        DatabaseDetailView detailView = (DatabaseDetailView)this.getSite().getPage().findView("net.sourceforge.sqlexplorer.plugin.views.DatabaseDetailView");
        if (detailView != null) {
            detailView.setSelectedNode(null);
        }
    }

    public DatabaseModel getActiveDatabase() {
        if (this._tabFolder == null) {
            return null;
        }
        TabItem item = this._tabFolder.getItem(this._tabFolder.getSelectionIndex());
        DatabaseModel model = (DatabaseModel)((TreeViewer)item.getData()).getInput();
        return model;
    }

    public void refreshSessionTrees(String sessionName) {
        if (this._tabFolder == null) {
            return;
        }
        TabItem[] items = this._tabFolder.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                TreeViewer viewer = (TreeViewer)items[i].getData();
                DatabaseModel model = (DatabaseModel)viewer.getInput();
                if (model.getSession().toString().equals(sessionName)) {
                    model.getRoot().refresh();
                    viewer.refresh();
                }
                ++i;
            }
        }
    }

    private void setDefaultMessage() {
        this.clearParent();
        String message = Messages.getString("DatabaseStructureView.NoSession");
        Label label = new Label(this._parent, 4);
        label.setText(message);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        this._parent.layout();
        this._parent.redraw();
    }

    public void setFocus() {
    }

    public void synchronizeDetailView(final DatabaseDetailView detailView) {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                IStructuredSelection selection;
                if (detailView == null) {
                    return;
                }
                if (DatabaseStructureView.this._tabFolder == null || DatabaseStructureView.this._tabFolder.getItemCount() == 0) {
                    return;
                }
                TreeViewer treeViewer = (TreeViewer)DatabaseStructureView.this._tabFolder.getItem(DatabaseStructureView.this._tabFolder.getSelectionIndex()).getData();
                INode selectedNode = null;
                if (treeViewer != null && (selection = (IStructuredSelection)treeViewer.getSelection()) != null && selection.getFirstElement() instanceof INode && (selectedNode = (INode)selection.getFirstElement()) instanceof ColumnNode) {
                    selectedNode = selectedNode.getParent();
                }
                detailView.setSelectedNode(selectedNode);
            }
        });
    }
}

