/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin.views;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.history.SQLHistory;
import net.sourceforge.sqlexplorer.history.SQLHistoryChangedListener;
import net.sourceforge.sqlexplorer.history.SQLHistoryElement;
import net.sourceforge.sqlexplorer.history.SQLHistoryLabelProvider;
import net.sourceforge.sqlexplorer.history.SQLHistorySearchListener;
import net.sourceforge.sqlexplorer.history.actions.OpenInEditorAction;
import net.sourceforge.sqlexplorer.history.actions.RemoveFromHistoryAction;
import net.sourceforge.sqlexplorer.history.actions.SQLHistoryActionGroup;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.util.TextUtil;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class SQLHistoryView
extends ViewPart
implements SQLHistoryChangedListener {
    private Text _searchBox;
    private Table _table;
    private TableViewer _tableViewer;
    private Label _tipLabelText;
    private Point _tipPosition;
    private Shell _tipShell;
    private Widget _tipWidget;

    public void changed() {
        this._tableViewer.getTable().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SQLHistory history = SQLExplorerPlugin.getDefault().getSQLHistory();
                SQLHistoryView.this._tableViewer.setItemCount(history.getEntryCount());
                SQLHistoryView.this._tableViewer.refresh();
            }
        });
    }

    public void createPartControl(Composite parent) {
        final SQLHistory history = SQLExplorerPlugin.getDefault().getSQLHistory();
        history.sort(1, 1024);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "net.sourceforge.sqlexplorer.SQLHistoryView");
        history.addListener(this);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginLeft = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this._searchBox = new Text(composite, 2048);
        this._searchBox.setLayoutData((Object)new GridData(4, 128, true, false));
        this._searchBox.setText(Messages.getString("SQLHistoryView.SearchText"));
        this._searchBox.selectAll();
        SQLHistorySearchListener searchListener = new SQLHistorySearchListener(history);
        this._searchBox.addModifyListener((ModifyListener)searchListener);
        this._searchBox.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Text searchbox = (Text)e.widget;
                if (searchbox.getText() != null && searchbox.getText().equals(Messages.getString("SQLHistoryView.SearchText"))) {
                    searchbox.setText("");
                }
            }
        });
        this._tableViewer = new TableViewer(composite, 268501762);
        this.getSite().setSelectionProvider((ISelectionProvider)this._tableViewer);
        this._table = this._tableViewer.getTable();
        this._table.setLayoutData((Object)new GridData(4, 4, true, true));
        this._table.setHeaderVisible(true);
        this._table.setLinesVisible(true);
        this._table.setItemCount(history.getEntryCount());
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new SQLHistoryLabelProvider());
        this._tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return SQLExplorerPlugin.getDefault().getSQLHistory().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this._tableViewer.setInput((Object)history);
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                TableColumn sortColumn = SQLHistoryView.this._table.getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = SQLHistoryView.this._table.getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    SQLHistoryView.this._table.setSortColumn(currentColumn);
                    dir = 128;
                }
                sortColumn = SQLHistoryView.this._table.getSortColumn();
                TableColumn[] cols = SQLHistoryView.this._table.getColumns();
                int i = 0;
                while (i < cols.length) {
                    if (cols[i] == sortColumn) {
                        history.sort(i, dir);
                        break;
                    }
                    ++i;
                }
                SQLHistoryView.this._table.setSortDirection(dir);
                SQLHistoryView.this._tableViewer.refresh();
            }
        };
        String[] columnLabels = new String[]{Messages.getString("SQLHistoryView.Column.SQL"), Messages.getString("SQLHistoryView.Column.Time"), Messages.getString("SQLHistoryView.Column.Connection"), Messages.getString("SQLHistoryView.Column.Executions")};
        this._tableViewer.setColumnProperties(columnLabels);
        int i = 0;
        while (i < columnLabels.length) {
            TableColumn column = new TableColumn(this._table, 16384);
            column.setText(columnLabels[i]);
            column.setMoveable(false);
            column.setResizable(true);
            column.addListener(13, sortListener);
            ++i;
        }
        this._tableViewer.refresh();
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(7, 150));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 120));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 50));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 50));
        this._table.setLayout((Layout)tableLayout);
        this._table.layout();
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                super.controlResized(e);
                TableLayout tableLayout = new TableLayout();
                tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(7, 150));
                tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 120));
                tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 50));
                tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 50));
                SQLHistoryView.this._table.setLayout((Layout)tableLayout);
            }
        });
        final IToolBarManager toolBarMgr = this.getViewSite().getActionBars().getToolBarManager();
        final SQLHistoryActionGroup actionGroup = new SQLHistoryActionGroup(this, history, this._tableViewer, toolBarMgr);
        this._tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                actionGroup.refresh();
                toolBarMgr.update(true);
            }
        });
        MenuManager menuMgr = new MenuManager("#HistoryPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Menu historyContextMenu = menuMgr.createContextMenu((Control)this._table);
        this._table.setMenu(historyContextMenu);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                toolBarMgr.markDirty();
                actionGroup.fillContextMenu(manager);
            }
        });
        final OpenInEditorAction openInEditorAction = new OpenInEditorAction();
        openInEditorAction.setTableViewer(this._tableViewer);
        openInEditorAction.setView(this);
        this._tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                openInEditorAction.run();
            }
        });
        final RemoveFromHistoryAction removeFromHistoryAction = new RemoveFromHistoryAction();
        removeFromHistoryAction.setTableViewer(this._tableViewer);
        this._table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    removeFromHistoryAction.run();
                }
            }
        });
        Display display = parent.getDisplay();
        this._tipShell = new Shell(parent.getShell(), 16384);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        this._tipShell.setLayout((Layout)gridLayout);
        this._tipShell.setBackground(display.getSystemColor(29));
        this._tipLabelText = new Label((Composite)this._tipShell, 16448);
        this._tipLabelText.setForeground(display.getSystemColor(28));
        this._tipLabelText.setBackground(display.getSystemColor(29));
        GridData gridData = new GridData(772);
        this._tipLabelText.setLayoutData((Object)gridData);
        this._table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (SQLHistoryView.this._tipShell.isVisible()) {
                    SQLHistoryView.this._tipShell.setVisible(false);
                    SQLHistoryView.this._tipWidget = null;
                }
            }
        });
        this._table.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                if (SQLHistoryView.this._tipShell.isVisible()) {
                    SQLHistoryView.this._tipShell.setVisible(false);
                }
                SQLHistoryView.this._tipWidget = null;
            }

            public void mouseHover(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                Widget widget = event.widget;
                TableItem tableItem = null;
                if (widget instanceof Table) {
                    Table table = (Table)widget;
                    widget = table.getItem(pt);
                }
                if (widget instanceof TableItem) {
                    tableItem = (TableItem)widget;
                }
                if (widget == null) {
                    SQLHistoryView.this._tipShell.setVisible(false);
                    SQLHistoryView.this._tipWidget = null;
                    return;
                }
                if (widget == SQLHistoryView.this._tipWidget) {
                    return;
                }
                SQLHistoryView.this._tipWidget = widget;
                SQLHistoryView.this._tipPosition = SQLHistoryView.this._table.toDisplay(pt);
                SQLHistoryElement sqlString = (SQLHistoryElement)tableItem.getData();
                String text = TextUtil.getWrappedText(sqlString.getRawSQLString());
                if (text == null || text.equals("")) {
                    SQLHistoryView.this._tipWidget = null;
                    return;
                }
                SQLHistoryView.this._table.setToolTipText("");
                SQLHistoryView.this._tipLabelText.setText(text);
                SQLHistoryView.this._tipShell.pack();
                SQLHistoryView.this.setHoverLocation(SQLHistoryView.this._tipShell, SQLHistoryView.this._tipPosition, ((SQLHistoryView)SQLHistoryView.this)._tipLabelText.getBounds().height);
                SQLHistoryView.this._tipShell.setVisible(true);
            }
        });
        this._tableViewer.setSelection(null);
        composite.layout();
        parent.layout();
    }

    public void dispose() {
        super.dispose();
        SQLExplorerPlugin.getDefault().getSQLHistory().removeListener(this);
    }

    public void setFocus() {
        this._searchBox.setFocus();
    }

    private void setHoverLocation(Shell shell, Point position, int labelHeight) {
        Rectangle displayBounds = shell.getDisplay().getBounds();
        Rectangle shellBounds = shell.getBounds();
        shellBounds.x = Math.max(Math.min(position.x, displayBounds.width - shellBounds.width), 0);
        shellBounds.y = Math.max(Math.min(position.y + 10, displayBounds.height - shellBounds.height), 0);
        if (shellBounds.y + labelHeight + 10 > displayBounds.height) {
            shellBounds.y = Math.max(position.y - labelHeight - 10, 0);
        }
        shell.setBounds(shellBounds);
    }
}

