/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin.views;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.sqlpanel.AbstractSQLExecution;
import net.sourceforge.sqlexplorer.sqlpanel.SQLResult;
import net.sourceforge.sqlexplorer.sqlpanel.actions.CloseSQLResultTab;
import net.sourceforge.sqlexplorer.util.TextUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class SqlResultsView
extends ViewPart {
    private int _lastTabNumber = 0;
    private Composite _parent;
    private SQLResult[] _results;
    private TabFolder _tabFolder;

    public void addSQLExecution(AbstractSQLExecution sqlExecution) {
        if (this._tabFolder == null || this._tabFolder.isDisposed()) {
            this.clearParent();
            this._tabFolder = new TabFolder(this._parent, 0);
            this._parent.layout();
            this._parent.redraw();
        }
        ++this._lastTabNumber;
        TabItem tabItem = new TabItem(this._tabFolder, 0);
        String labelText = "" + this._lastTabNumber;
        tabItem.setText(labelText);
        tabItem.setData("tabLabel", (Object)labelText);
        tabItem.setToolTipText(TextUtil.getWrappedText(sqlExecution.getSqlStatement()));
        Composite composite = new Composite((Composite)this._tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginLeft = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        tabItem.setControl((Control)composite);
        tabItem.setData((Object)sqlExecution);
        tabItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this, e){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ DisposeEvent val$e;
                    {
                        this.this$1 = var1_1;
                        this.val$e = disposeEvent;
                    }

                    public void run() {
                        TabItem tabItem = (TabItem)this.val$e.getSource();
                        AbstractSQLExecution sqlExecution = (AbstractSQLExecution)tabItem.getData();
                        sqlExecution.stop();
                        tabItem.setData(null);
                        if (SqlResultsView.access$0(1.access$0(this.this$1)) != null && !SqlResultsView.access$0(1.access$0(this.this$1)).isDisposed()) {
                            if (SqlResultsView.access$0(1.access$0(this.this$1)).getItemCount() == 0) {
                                SqlResultsView.access$1(1.access$0(this.this$1));
                                SqlResultsView.access$2(1.access$0(this.this$1));
                            }
                        } else if (SqlResultsView.access$0(1.access$0(this.this$1)).isDisposed()) {
                            SqlResultsView.access$1(1.access$0(this.this$1));
                            SqlResultsView.access$2(1.access$0(this.this$1));
                        }
                    }
                });
            }

            static /* synthetic */ SqlResultsView access$0(1 var0) {
                return var0.SqlResultsView.this;
            }
        });
        String sqlStatement = sqlExecution.getSqlStatement();
        int labelHeight = 60;
        int labelStyle = 66;
        Text tmpLabel = new Text(composite, labelStyle);
        tmpLabel.setText(TextUtil.removeLineBreaks(sqlExecution.getSqlStatement()));
        tmpLabel.setLayoutData((Object)new FillLayout());
        int parentWidth = this._parent.getClientArea().width;
        Point idealSize = tmpLabel.computeSize(parentWidth - 30, -1);
        if (idealSize.y <= 60) {
            labelHeight = idealSize.y;
        } else {
            labelStyle = 578;
        }
        tmpLabel.dispose();
        Composite headerComposite = new Composite(composite, 4);
        headerComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout hLayout = new GridLayout();
        hLayout.numColumns = 2;
        hLayout.marginLeft = 0;
        hLayout.horizontalSpacing = 0;
        hLayout.verticalSpacing = 0;
        hLayout.marginWidth = 0;
        hLayout.marginHeight = 0;
        headerComposite.setLayout((Layout)hLayout);
        Text label = new Text(headerComposite, labelStyle);
        label.setEditable(false);
        label.setBackground(this._parent.getBackground());
        label.setText(TextUtil.removeLineBreaks(sqlStatement));
        label.setToolTipText(TextUtil.getWrappedText(sqlStatement));
        GridData labelGridData = new GridData(4, 128, true, false);
        labelGridData.heightHint = labelHeight;
        label.setLayoutData((Object)labelGridData);
        ToolBarManager toolBarMgr = new ToolBarManager(0x800000);
        toolBarMgr.createControl(headerComposite);
        toolBarMgr.add((IAction)new CloseSQLResultTab(tabItem));
        toolBarMgr.update(true);
        GridData gid = new GridData();
        gid.horizontalAlignment = 131072;
        gid.verticalAlignment = 128;
        toolBarMgr.getControl().setLayoutData((Object)gid);
        Composite detailComposite = new Composite(composite, 4);
        detailComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        sqlExecution.setComposite(detailComposite);
        sqlExecution.setParentTab(tabItem);
        sqlExecution.startExecution();
        this._tabFolder.setSelection(this._tabFolder.getItemCount() - 1);
        composite.layout();
        this._tabFolder.layout();
        this._tabFolder.redraw();
        this.getSite().getPage().bringToTop((IWorkbenchPart)this);
    }

    private void clearParent() {
        Control[] children = this._parent.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        this._lastTabNumber = 0;
    }

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "net.sourceforge.sqlexplorer.SQLResultsView");
        this._parent = parent;
        if (this._results == null || this._results.length == 0) {
            this.setDefaultMessage();
        }
    }

    private void setDefaultMessage() {
        this.clearParent();
        String message = Messages.getString("SQLResultsView.NoResults");
        Label label = new Label(this._parent, 4);
        label.setText(message);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        this._parent.layout();
        this._parent.redraw();
    }

    public void setFocus() {
    }

    static /* synthetic */ TabFolder access$0(SqlResultsView sqlResultsView) {
        return sqlResultsView._tabFolder;
    }

    static /* synthetic */ void access$1(SqlResultsView sqlResultsView) {
        sqlResultsView.clearParent();
    }

    static /* synthetic */ void access$2(SqlResultsView sqlResultsView) {
        sqlResultsView.setDefaultMessage();
    }
}

