/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.preferences;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.preferences.ColorEditor;
import net.sourceforge.sqlexplorer.preferences.OverlayPreferenceStore;
import net.sourceforge.sqlexplorer.sqleditor.SQLTextViewer;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SQLPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String BOLD = "_bold";
    private FontFieldEditor fFontEditor;
    List fSyntaxColorList;
    ColorEditor fSyntaxForegroundColorEditor;
    Button fBoldCheckBox;
    Button btn4;
    Button btn1;
    Button btn2;
    Button btn3;
    SQLTextViewer fPreviewViewer;
    OverlayPreferenceStore fOverlayStore;
    public final OverlayPreferenceStore.OverlayKey[] fKeys = new OverlayPreferenceStore.OverlayKey[]{new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "SQLEditor.Font"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "SQLEditor.MultiLineCommentColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "SQLEditor.MultiLineCommentColor_bold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "SQLEditor.TableColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "SQLEditor.TableColor_bold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "SQLEditor.ColumnsColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "SQLEditor.ColumnsColor_bold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "SQLEditor.SingleLineCommentColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "SQLEditor.SingleLineCommentColor_bold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "SQLEditor.DefaultColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "SQLEditor.DefaultColor_bold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "SQLEditor.StringColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "SQLEditor.StringColor_bold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "SQLEditor.KeywordColor"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "SQLEditor.KeywordColor_bold"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "SQLEditor.ClipExportColumns"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "SQLEditor.ClipExportSeparator")};
    final String[][] fSyntaxColorListModel = new String[][]{{Messages.getString("SQL_Table_1"), "SQLEditor.TableColor"}, {Messages.getString("SQL_Column_2"), "SQLEditor.ColumnsColor"}, {Messages.getString("SQL_Keyword_3"), "SQLEditor.KeywordColor"}, {Messages.getString("SQL_Single_Line_Comment_4"), "SQLEditor.SingleLineCommentColor"}, {Messages.getString("SQL_Multi_Line_Comment_5"), "SQLEditor.MultiLineCommentColor"}, {Messages.getString("String_6"), "SQLEditor.StringColor"}, {Messages.getString("Others_7"), "SQLEditor.DefaultColor"}};

    public SQLPreferencePage() {
        this.fOverlayStore = new OverlayPreferenceStore(SQLExplorerPlugin.getDefault().getPreferenceStore(), this.fKeys);
        this.fOverlayStore.load();
        this.fOverlayStore.start();
    }

    public void init(IWorkbench workbench) {
    }

    public SQLPreferencePage(OverlayPreferenceStore fOverlayStore) {
        super(Messages.getString("SQL_Preferences_1"));
        this.fOverlayStore = fOverlayStore;
        this.setTitle(Messages.getString("Sql_Editor_Preferences_2"));
    }

    protected Control createContents(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        Group fntGroup = new Group(colorComposite, 0);
        fntGroup.setLayout((Layout)new GridLayout());
        fntGroup.setLayoutData((Object)new GridData(256));
        fntGroup.setText(Messages.getString("Font_Properties_1"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite fntComposite = new Composite((Composite)fntGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        fntComposite.setLayout((Layout)layout);
        this.fFontEditor = new FontFieldEditor("key", Messages.getString("Text_Font__3"), fntComposite);
        this.fFontEditor.setLabelText(Messages.getString("Text_Font__4"));
        this.fFontEditor.setChangeButtonText(Messages.getString("Change_5"));
        this.fFontEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SQLPreferencePage.this.handleFont();
            }
        });
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        fntComposite.setLayoutData((Object)gd);
        Group colorGroup = new Group(colorComposite, 0);
        colorGroup.setLayout((Layout)new GridLayout());
        colorGroup.setLayoutData((Object)new GridData(256));
        colorGroup.setText(Messages.getString("Text_Properties_6"));
        Composite editorComposite = new Composite((Composite)colorGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1808);
        editorComposite.setLayoutData((Object)gd);
        this.fSyntaxColorList = new List(editorComposite, 2564);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fSyntaxColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(stylesComposite, 16384);
        label.setText(Messages.getString("Color_9"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fSyntaxForegroundColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fSyntaxForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setText(Messages.getString("Bold_10"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        Group previewGroup = new Group(colorComposite, 0);
        previewGroup.setLayout((Layout)new GridLayout());
        previewGroup.setLayoutData((Object)new GridData(256));
        previewGroup.setText(Messages.getString("Preview_7"));
        Control previewer = this.createPreviewer((Composite)previewGroup);
        gd = new GridData(1808);
        previewer.setLayoutData((Object)gd);
        this.fSyntaxColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SQLPreferencePage.this.handleSyntaxColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = SQLPreferencePage.this.fSyntaxColorList.getSelectionIndex();
                String key = SQLPreferencePage.this.fSyntaxColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)SQLPreferencePage.this.fOverlayStore, (String)key, (RGB)SQLPreferencePage.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = SQLPreferencePage.this.fSyntaxColorList.getSelectionIndex();
                String key = SQLPreferencePage.this.fSyntaxColorListModel[i][1];
                SQLPreferencePage.this.fOverlayStore.setValue(String.valueOf(key) + SQLPreferencePage.BOLD, SQLPreferencePage.this.fBoldCheckBox.getSelection());
            }
        });
        Group exportGroup = new Group(colorComposite, 0);
        exportGroup.setLayout((Layout)new GridLayout());
        exportGroup.setLayoutData((Object)new GridData(256));
        exportGroup.setText(Messages.getString("Export_to_Clipboard_1"));
        Label lbt1 = new Label((Composite)exportGroup, 0);
        lbt1.setText("Separator");
        this.btn1 = new Button((Composite)exportGroup, 16);
        this.btn1.setText(";");
        this.btn1.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SQLPreferencePage.this.fOverlayStore.setValue("SQLEditor.ClipExportSeparator", ";");
            }
        });
        this.btn2 = new Button((Composite)exportGroup, 16);
        this.btn2.setText("|");
        this.btn2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SQLPreferencePage.this.fOverlayStore.setValue("SQLEditor.ClipExportSeparator", "|");
            }
        });
        this.btn3 = new Button((Composite)exportGroup, 16);
        this.btn3.setText("\\t [TAB]");
        this.btn3.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SQLPreferencePage.this.fOverlayStore.setValue("SQLEditor.ClipExportSeparator", "\t");
            }
        });
        this.btn4 = new Button((Composite)exportGroup, 32);
        this.btn4.setText("Export column names");
        this.btn4.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SQLPreferencePage.this.fOverlayStore.setValue("SQLEditor.ClipExportColumns", SQLPreferencePage.this.btn4.getSelection());
            }
        });
        this.initialize();
        return colorComposite;
    }

    private Control createPreviewer(Composite parent) {
        this.fPreviewViewer = new SQLTextViewer(parent, 2816, this.fOverlayStore, null);
        this.fPreviewViewer.setEditable(false);
        String separator = System.getProperty("line.separator");
        String content = String.valueOf(Messages.getString("select_*_from_MyTable_--_single_line_comment_12")) + separator + Messages.getString("/*_multi_line_comment_13") + separator + Messages.getString("select_*_14") + separator + Messages.getString("end_multi_line_comment*/_15") + separator + Messages.getString("where_A___1___16");
        Document document = new Document(content);
        this.fPreviewViewer.setDocument((IDocument)document);
        this.fOverlayStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SQLPreferencePage.this.fPreviewViewer.invalidateTextPresentation();
            }
        });
        return this.fPreviewViewer.getControl();
    }

    void handleSyntaxColorListSelection() {
        int i = this.fSyntaxColorList.getSelectionIndex();
        String key = this.fSyntaxColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fSyntaxForegroundColorEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.fOverlayStore.getBoolean(String.valueOf(key) + BOLD));
    }

    void handleFont() {
        this.fFontEditor.store();
        FontData[] fData = PreferenceConverter.getFontDataArray((IPreferenceStore)this.fOverlayStore, (String)"SQLEditor.Font");
        String des = this.fOverlayStore.getString("SQLEditor.Font");
        if (fData.length > 0) {
            JFaceResources.getFontRegistry().put(des, fData);
            this.fPreviewViewer.getControl().setFont(JFaceResources.getFontRegistry().get(des));
        }
    }

    private void initialize() {
        int i = 0;
        while (i < this.fSyntaxColorListModel.length) {
            this.fSyntaxColorList.add(this.fSyntaxColorListModel[i][0]);
            ++i;
        }
        this.fSyntaxColorList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                SQLPreferencePage.this.fSyntaxColorList.select(0);
                SQLPreferencePage.this.handleSyntaxColorListSelection();
            }
        });
        this.fFontEditor.setPreferenceStore((IPreferenceStore)this.fOverlayStore);
        this.fFontEditor.setPreferenceName("font");
        this.fFontEditor.setPage((DialogPage)this);
        this.fFontEditor.load();
        FontData[] fData = PreferenceConverter.getFontDataArray((IPreferenceStore)this.fOverlayStore, (String)"SQLEditor.Font");
        if (fData.length > 0) {
            JFaceResources.getFontRegistry().put(fData[0].toString(), fData);
            this.fPreviewViewer.getControl().setFont(JFaceResources.getFontRegistry().get(fData[0].toString()));
        }
        this.btn4.getDisplay().asyncExec(new Runnable(){

            public void run() {
                SQLPreferencePage.this.btn4.setSelection(SQLPreferencePage.this.fOverlayStore.getBoolean("SQLEditor.ClipExportColumns"));
            }
        });
        String sep = this.fOverlayStore.getString("SQLEditor.ClipExportSeparator");
        if (sep.equals(";")) {
            this.btn1.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    SQLPreferencePage.this.btn1.setSelection(true);
                    SQLPreferencePage.this.btn2.setSelection(false);
                    SQLPreferencePage.this.btn3.setSelection(false);
                }
            });
        } else if (sep.equals("|")) {
            this.btn1.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    SQLPreferencePage.this.btn1.setSelection(false);
                    SQLPreferencePage.this.btn2.setSelection(true);
                    SQLPreferencePage.this.btn3.setSelection(false);
                }
            });
        } else if (sep.equals("\\t")) {
            this.btn1.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    SQLPreferencePage.this.btn1.setSelection(false);
                    SQLPreferencePage.this.btn2.setSelection(false);
                    SQLPreferencePage.this.btn3.setSelection(true);
                }
            });
        }
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.handleSyntaxColorListSelection();
        if (this.fFontEditor != null) {
            this.fFontEditor.loadDefault();
        }
        super.performDefaults();
        this.fPreviewViewer.invalidateTextPresentation();
        FontData[] fData = PreferenceConverter.getFontDataArray((IPreferenceStore)this.fOverlayStore, (String)"SQLEditor.Font");
        if (fData.length > 0) {
            JFaceResources.getFontRegistry().put(fData[0].toString(), fData);
            this.fPreviewViewer.getControl().setFont(JFaceResources.getFontRegistry().get(fData[0].toString()));
        }
    }

    public void dispose() {
        if (this.fFontEditor != null) {
            this.fFontEditor.setPreferenceStore(null);
            this.fFontEditor.setPage(null);
        }
        this.setPreferenceStore(null);
        super.dispose();
    }

    public boolean performOk() {
        if (this.fFontEditor != null) {
            this.fFontEditor.store();
        }
        this.fOverlayStore.propagate();
        return true;
    }
}

