/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sessiontree.model.utility;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.utility.Dictionary;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DictionaryLoader
extends Job {
    private SessionTreeNode _sessionNode;
    private static final String ID = "net.sourceforge.sqlexplorer";

    private DictionaryLoader() {
        super(null);
    }

    public DictionaryLoader(SessionTreeNode sessionNode) {
        super(Messages.getString("Progress.Dictionary.Title"));
        this._sessionNode = sessionNode;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        Dictionary dictionary = this._sessionNode.getDictionary();
        monitor.setTaskName(Messages.getString("Progress.Dictionary.Scanning"));
        try {
            try {
                boolean isLoaded = dictionary.restore(this._sessionNode.getRoot(), monitor);
                if (!isLoaded) {
                    dictionary.load(this._sessionNode.getRoot(), monitor);
                    monitor.done();
                }
            }
            catch (InterruptedException interruptedException) {
                Status status = new Status(8, ID, 8, Messages.getString("Progress.Dictionary.Cancelled"), null);
                Object var4_7 = null;
                monitor.done();
                return status;
            }
            catch (Exception e) {
                Status status = new Status(4, ID, 8, Messages.getString("Progress.Dictionary.Error"), (Throwable)e);
                Object var4_8 = null;
                monitor.done();
                return status;
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_10 = null;
        }
        monitor.done();
        return new Status(0, ID, 0, "tested ok ", null);
    }
}

