/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sqleditor;

import net.sourceforge.sqlexplorer.sqleditor.SQLCompletionProcessor;
import net.sourceforge.sqlexplorer.sqleditor.SQLTextTools;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Shell;

public class SQLSourceViewerConfiguration
extends SourceViewerConfiguration {
    InformationPresenter iPresenter;
    private SQLTextTools fSQLTextTools;
    private IDocumentPartitioner docPartitioner;
    private DefaultTextDoubleClickStrategy defaultTextDoubleClickStrategy = new DefaultTextDoubleClickStrategy();

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return this.defaultTextDoubleClickStrategy;
    }

    public SQLSourceViewerConfiguration(SQLTextTools tools) {
        this.fSQLTextTools = tools;
        this.docPartitioner = tools.createDocumentPartitioner();
    }

    public IDocumentPartitioner getDocumentPartitioner() {
        return this.docPartitioner;
    }

    public RuleBasedScanner getCodeScanner() {
        return this.fSQLTextTools.getCodeScanner();
    }

    protected RuleBasedScanner getMultilineCommentScanner() {
        return this.fSQLTextTools.getMultilineCommentScanner();
    }

    protected RuleBasedScanner getSinglelineCommentScanner() {
        return this.fSQLTextTools.getSinglelineCommentScanner();
    }

    protected RuleBasedScanner getStringScanner() {
        return this.fSQLTextTools.getStringScanner();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getMultilineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "SQLEditor.MultiLineCommentColor");
        reconciler.setRepairer((IPresentationRepairer)dr, "SQLEditor.MultiLineCommentColor");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSinglelineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "SQLEditor.SingleLineCommentColor");
        reconciler.setRepairer((IPresentationRepairer)dr, "SQLEditor.SingleLineCommentColor");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "SQLEditor.StringColor");
        reconciler.setRepairer((IPresentationRepairer)dr, "SQLEditor.StringColor");
        return reconciler;
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return 4;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant(){

            public void uninstall() {
                SQLCompletionProcessor p1 = (SQLCompletionProcessor)this.getContentAssistProcessor("SQLEditor.StringColor");
                SQLCompletionProcessor p2 = (SQLCompletionProcessor)this.getContentAssistProcessor("SQLEditor.SingleLineCommentColor");
                p1.dispose();
                p2.dispose();
                super.uninstall();
            }
        };
        SQLCompletionProcessor processor = new SQLCompletionProcessor(this.fSQLTextTools.getDictionary());
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "SQLEditor.StringColor");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "SQLEditor.SingleLineCommentColor");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.enableAutoInsert(true);
        assistant.enableAutoActivation(true);
        processor.setCompletionProposalAutoActivationCharacters(".".toCharArray());
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        if (this.iPresenter == null) {
            IInformationControlCreator informationControlCreator = new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent);
                }
            };
            this.iPresenter = new InformationPresenter(informationControlCreator);
            this.iPresenter.setSizeConstraints(60, 10, true, true);
        }
        return this.iPresenter;
    }
}

