/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sqleditor;

import net.sourceforge.sqlexplorer.sessiontree.model.utility.Dictionary;
import net.sourceforge.sqlexplorer.sqleditor.SQLCodeScanner;
import net.sourceforge.sqlexplorer.sqleditor.SQLColorManager;
import net.sourceforge.sqlexplorer.sqleditor.SQLPartitionScanner;
import net.sourceforge.sqlexplorer.sqleditor.SingleTokenSQLScanner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class SQLTextTools {
    private SQLColorManager fColorManager;
    private SQLCodeScanner fCodeScanner;
    private SingleTokenSQLScanner fMultilineCommentScanner;
    private SingleTokenSQLScanner fSinglelineCommentScanner;
    private SingleTokenSQLScanner fStringScanner;
    private SQLPartitionScanner fPartitionScanner;
    private IPreferenceStore fPreferenceStore;
    private PreferenceListener fPreferenceListener = new PreferenceListener();
    private Dictionary dictionary;

    public SQLTextTools(IPreferenceStore store, Dictionary dictionary) {
        this.fPreferenceStore = store;
        this.dictionary = dictionary;
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.fColorManager = new SQLColorManager();
        this.fCodeScanner = new SQLCodeScanner(this.fColorManager, store, dictionary);
        this.fMultilineCommentScanner = new SingleTokenSQLScanner(this.fColorManager, store, "SQLEditor.MultiLineCommentColor");
        this.fSinglelineCommentScanner = new SingleTokenSQLScanner(this.fColorManager, store, "SQLEditor.SingleLineCommentColor");
        this.fStringScanner = new SingleTokenSQLScanner(this.fColorManager, store, "SQLEditor.StringColor");
        this.fPartitionScanner = new SQLPartitionScanner();
    }

    public void setNewDictionary(Dictionary newDictionary) {
        this.dictionary = newDictionary;
        this.fCodeScanner = new SQLCodeScanner(this.fColorManager, this.fPreferenceStore, newDictionary);
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public void dispose() {
        this.fCodeScanner = null;
        this.fMultilineCommentScanner = null;
        this.fSinglelineCommentScanner = null;
        this.fStringScanner = null;
        this.fPartitionScanner = null;
        if (this.fColorManager != null) {
            this.fColorManager.dispose();
            this.fColorManager = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
            this.fPreferenceStore = null;
            this.fPreferenceListener = null;
        }
    }

    public RuleBasedScanner getCodeScanner() {
        return this.fCodeScanner;
    }

    public RuleBasedScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    public RuleBasedScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    public RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    public IPartitionTokenScanner getPartitionScanner() {
        return this.fPartitionScanner;
    }

    public IDocumentPartitioner createDocumentPartitioner() {
        String[] types = new String[]{"__dftl_partition_content_type", "SQLEditor.MultiLineCommentColor", "SQLEditor.SingleLineCommentColor", "SQLEditor.StringColor"};
        return new FastPartitioner(this.getPartitionScanner(), types);
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fMultilineCommentScanner.affectsBehavior(event) || this.fSinglelineCommentScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event);
    }

    protected void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(event)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(event)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
    }

    private class PreferenceListener
    implements IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            SQLTextTools.this.adaptToPreferenceChange(event);
        }
    }
}

