/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sqleditor.actions;

import java.util.ArrayList;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.views.SqlResultsView;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.sqlexplorer.sqleditor.actions.AbstractEditorAction;
import net.sourceforge.sqlexplorer.sqlpanel.SQLExecution;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import net.sourceforge.sqlexplorer.util.QueryTokenizer;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;

public class ExecSQLAction
extends AbstractEditorAction {
    private ImageDescriptor img = ImageUtil.getDescriptor("Images.ExecSQLIcon");

    public ImageDescriptor getImageDescriptor() {
        return this.img;
    }

    public String getText() {
        return Messages.getString("SQLEditor.Actions.Execute");
    }

    public String getToolTipText() {
        return Messages.getString("SQLEditor.Actions.Execute.ToolTip");
    }

    public void run() {
        if (this._editor.getLimitResults() == null || this._editor.getMaxResultField() == null) {
            return;
        }
        int maxresults = 0;
        try {
            String tmp;
            if (this._editor.getLimitResults().getSelection() && (tmp = this._editor.getMaxResultField().getText()) != null && tmp.trim().length() != 0) {
                maxresults = Integer.parseInt(tmp);
            }
        }
        catch (Exception e) {
            this._editor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)ExecSQLAction.this._editor.getSite().getShell(), (String)Messages.getString("SQLEditor.Error.InvalidRowLimit.Title"), (String)(String.valueOf(Messages.getString("SQLEditor.Error.InvalidRowLimit.")) + " " + e.getMessage()));
                }
            });
            return;
        }
        try {
            if (maxresults < 0) {
                throw new Exception(Messages.getString("SQLEditor.LimitRows.Error"));
            }
            final ExecSQLAction action = this;
            boolean warnNoLimit = SQLExplorerPlugin.getDefault().getPluginPreferences().getBoolean("SQLEditor.WarnIfLargeLimit");
            int warnLimit = SQLExplorerPlugin.getDefault().getPluginPreferences().getInt("SQLEditor.WarnLimit");
            if (warnNoLimit && (maxresults == 0 || maxresults > warnLimit)) {
                final int largeResults = maxresults;
                this._editor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        boolean okToExecute = MessageDialog.openConfirm((Shell)ExecSQLAction.this._editor.getSite().getShell(), (String)Messages.getString("SQLEditor.LimitRows.ConfirmNoLimit.Title"), (String)Messages.getString("SQLEditor.LimitRows.ConfirmNoLimit.Message"));
                        if (okToExecute) {
                            action.run(largeResults);
                        }
                    }
                });
            } else {
                action.run(maxresults);
            }
        }
        catch (Exception e) {
            this._editor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)ExecSQLAction.this._editor.getSite().getShell(), (String)Messages.getString("SQLResultsView.Error.Title"), (String)e.getMessage());
                }
            });
        }
    }

    protected void run(int maxRows) {
        SessionTreeNode runNode = this._editor.getSessionTreeNode();
        if (runNode == null) {
            return;
        }
        Preferences prefs = SQLExplorerPlugin.getDefault().getPluginPreferences();
        String queryDelimiter = prefs.getString("SQLEditor.QueryDelimiter");
        String alternateDelimiter = prefs.getString("SQLEditor.AltQueryDelimiter");
        String commentDelimiter = prefs.getString("SQLEditor.CommentDelimiter");
        QueryTokenizer qt = new QueryTokenizer(this._editor.getSQLToBeExecuted(), queryDelimiter, alternateDelimiter, commentDelimiter);
        ArrayList<String> queryStrings = new ArrayList<String>();
        while (qt.hasQuery()) {
            String querySql = qt.nextQuery();
            if (querySql.startsWith("--")) continue;
            queryStrings.add(querySql);
        }
        try {
            SqlResultsView resultsView = (SqlResultsView)this._editor.getSite().getPage().showView("net.sourceforge.sqlexplorer.plugin.views.SqlResultsView");
            while (!queryStrings.isEmpty()) {
                String querySql = (String)queryStrings.remove(0);
                if (querySql == null) continue;
                resultsView.addSQLExecution(new SQLExecution(this._editor, resultsView, querySql, maxRows, runNode));
            }
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Error creating sql execution tab", e);
        }
    }
}

