/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sqleditor.actions;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SQLEditorSessionSwitcher
extends ControlContribution {
    private SQLEditor _editor;
    private Combo _sessionCombo;

    public SQLEditorSessionSwitcher(SQLEditor editor) {
        super("net.sourceforge.sqlexplorer.sessionswitcher");
        this._editor = editor;
    }

    protected Control createControl(Composite parent) {
        this._sessionCombo = new Combo(parent, 8);
        this._sessionCombo.setToolTipText(Messages.getString("SQLEditor.Actions.ChooseSession.ToolTip"));
        this._sessionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionTreeNode sessionTreeNode = null;
                int selIndex = SQLEditorSessionSwitcher.this._sessionCombo.getSelectionIndex();
                if (selIndex != 0) {
                    sessionTreeNode = SQLExplorerPlugin.getDefault().stm.getRoot().getSessionTreeNodes()[selIndex - 1];
                }
                SQLEditorSessionSwitcher.this._editor.setSessionTreeNode(sessionTreeNode);
                SQLEditorSessionSwitcher.this._editor.getEditorToolBar().refresh(true);
            }
        });
        this.setSessionOptions();
        return this._sessionCombo;
    }

    private void setSessionOptions() {
        SessionTreeNode[] sessionNodes = SQLExplorerPlugin.getDefault().stm.getRoot().getSessionTreeNodes();
        this._sessionCombo.removeAll();
        this._sessionCombo.add("");
        int i = 0;
        while (i < sessionNodes.length) {
            this._sessionCombo.add(sessionNodes[i].toString());
            if (this._editor.getSessionTreeNode() == sessionNodes[i]) {
                this._sessionCombo.select(this._sessionCombo.getItemCount() - 1);
            }
            ++i;
        }
    }

    public void refresh() {
        this.setSessionOptions();
    }
}

