/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sqleditor.actions;

import java.util.ArrayList;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.sqlexplorer.sqleditor.actions.AbstractEditorAction;
import net.sourceforge.sqlexplorer.sqleditor.actions.ClearTextAction;
import net.sourceforge.sqlexplorer.sqleditor.actions.CommitAction;
import net.sourceforge.sqlexplorer.sqleditor.actions.ExecSQLAction;
import net.sourceforge.sqlexplorer.sqleditor.actions.OpenFileAction;
import net.sourceforge.sqlexplorer.sqleditor.actions.RollbackAction;
import net.sourceforge.sqlexplorer.sqleditor.actions.SQLEditorCatalogSwitcher;
import net.sourceforge.sqlexplorer.sqleditor.actions.SQLEditorSessionSwitcher;
import net.sourceforge.sqlexplorer.sqleditor.actions.SaveFileAsAction;
import net.sourceforge.sqlexplorer.util.ImageUtil;
import net.sourceforge.sqlexplorer.util.TextUtil;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;

public class SQLEditorToolBar {
    private SQLEditorCatalogSwitcher _catalogSwitcher;
    private ToolBarManager _catalogToolBarMgr;
    private AbstractEditorAction _clearTextAction;
    private AbstractEditorAction _commitAction;
    private CoolBar _coolBar;
    private CoolBarManager _coolBarMgr;
    private ToolBarManager _defaultToolBarMgr;
    private SQLEditor _editor;
    private AbstractEditorAction _execSQLAction;
    private ToolBarManager _extensionToolBarMgr;
    private AbstractEditorAction _openFileAction;
    private AbstractEditorAction _rollbackAction;
    private AbstractEditorAction _saveAsAction;
    private SQLEditorSessionSwitcher _sessionSwitcher;
    private ToolBarManager _sessionToolBarMgr;

    public SQLEditorToolBar(Composite parent, SQLEditor editor) {
        this._editor = editor;
        this._coolBar = new CoolBar(parent, 0x800000);
        this._coolBarMgr = new CoolBarManager(this._coolBar);
        GridData gid = new GridData();
        gid.horizontalAlignment = 4;
        this._coolBar.setLayoutData((Object)gid);
        this._defaultToolBarMgr = new ToolBarManager(0x800000);
        this._execSQLAction = new ExecSQLAction();
        this._execSQLAction.setEditor(this._editor);
        this._commitAction = new CommitAction();
        this._commitAction.setEditor(this._editor);
        this._rollbackAction = new RollbackAction();
        this._rollbackAction.setEditor(this._editor);
        this._openFileAction = new OpenFileAction();
        this._openFileAction.setEditor(this._editor);
        this._saveAsAction = new SaveFileAsAction();
        this._saveAsAction.setEditor(this._editor);
        this._clearTextAction = new ClearTextAction();
        this._clearTextAction.setEditor(this._editor);
        this.addDefaultActions(this._defaultToolBarMgr);
        this._extensionToolBarMgr = new ToolBarManager(0x800000);
        this.createExtensionActions(this._extensionToolBarMgr);
        this._sessionToolBarMgr = new ToolBarManager(0x800000);
        this._sessionSwitcher = new SQLEditorSessionSwitcher(editor);
        this._sessionToolBarMgr.add((IContributionItem)this._sessionSwitcher);
        this._catalogToolBarMgr = new ToolBarManager(0x800000);
        if (this._editor.getSessionTreeNode() != null && this._editor.getSessionTreeNode().supportsCatalogs()) {
            this._catalogSwitcher = new SQLEditorCatalogSwitcher(editor);
            this._catalogToolBarMgr.add((IContributionItem)this._catalogSwitcher);
        }
        this._coolBarMgr.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)this._defaultToolBarMgr));
        this._coolBarMgr.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)this._extensionToolBarMgr));
        this._coolBarMgr.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)this._sessionToolBarMgr));
        this._coolBarMgr.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)this._catalogToolBarMgr));
        this._coolBarMgr.update(true);
    }

    public void addResizeListener(ControlListener listener) {
        this._coolBar.addControlListener(listener);
    }

    private void createExtensionActions(ToolBarManager mgr) {
        mgr.removeAll();
        IAction[] toolActions = this.getEditorActions();
        if (toolActions != null) {
            int i = 0;
            while (i < toolActions.length) {
                mgr.add(toolActions[i]);
                ++i;
            }
        }
    }

    private void addDefaultActions(ToolBarManager mgr) {
        mgr.removeAll();
        this._execSQLAction.setEnabled(!this._execSQLAction.isDisabled());
        this._commitAction.setEnabled(!this._commitAction.isDisabled());
        this._rollbackAction.setEnabled(!this._rollbackAction.isDisabled());
        mgr.add((IAction)this._execSQLAction);
        mgr.add((IAction)this._commitAction);
        mgr.add((IAction)this._rollbackAction);
        mgr.add((IAction)this._openFileAction);
        mgr.add((IAction)this._saveAsAction);
        mgr.add((IAction)this._clearTextAction);
    }

    private IAction[] getEditorActions() {
        SessionTreeNode tree = this._editor.getSessionTreeNode();
        if (tree == null) {
            return null;
        }
        String databaseProductName = tree.getRoot().getDatabaseProductName().toLowerCase().trim();
        ArrayList<AbstractEditorAction> actions = new ArrayList<AbstractEditorAction>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("net.sourceforge.sqlexplorer", "editorAction");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension e = extensions[i];
            IConfigurationElement[] ces = e.getConfigurationElements();
            int j = 0;
            while (j < ces.length) {
                try {
                    boolean isValidProduct = false;
                    String[] validProducts = ces[j].getAttribute("database-product-name").split(",");
                    String imagePath = ces[j].getAttribute("icon");
                    String id = ces[j].getAttribute("id");
                    int k = 0;
                    while (k < validProducts.length) {
                        String product = validProducts[k].toLowerCase().trim();
                        if (product.length() != 0) {
                            if (product.equals("*")) {
                                isValidProduct = true;
                                break;
                            }
                            String regex = TextUtil.replaceChar(product, '*', ".*");
                            if (databaseProductName.matches(regex)) {
                                isValidProduct = true;
                                break;
                            }
                        }
                        ++k;
                    }
                    if (isValidProduct) {
                        AbstractEditorAction action = (AbstractEditorAction)((Object)ces[j].createExecutableExtension("class"));
                        action.setEditor(this._editor);
                        String fragmentId = id.substring(0, id.indexOf(46, 28));
                        if (imagePath != null && imagePath.trim().length() != 0) {
                            action.setImageDescriptor(ImageUtil.getFragmentDescriptor(fragmentId, imagePath));
                        }
                        actions.add(action);
                    }
                }
                catch (Throwable ex) {
                    SQLExplorerPlugin.error("Could not create editor action", ex);
                }
                ++j;
            }
            ++i;
        }
        return actions.toArray(new IAction[0]);
    }

    public void refresh(final boolean sessionChanged) {
        this._editor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (sessionChanged) {
                    SQLEditorToolBar.this.addDefaultActions(SQLEditorToolBar.this._defaultToolBarMgr);
                    SQLEditorToolBar.this._defaultToolBarMgr.update(true);
                    SQLEditorToolBar.this.createExtensionActions(SQLEditorToolBar.this._extensionToolBarMgr);
                    SQLEditorToolBar.this._extensionToolBarMgr.update(true);
                }
                SQLEditorToolBar.this._sessionSwitcher.refresh();
                SQLEditorToolBar.this._sessionToolBarMgr.update(true);
                SQLEditorToolBar.this._catalogToolBarMgr.removeAll();
                if (SQLEditorToolBar.this._editor.getSessionTreeNode() != null && SQLEditorToolBar.this._editor.getSessionTreeNode().supportsCatalogs()) {
                    SQLEditorToolBar.this._catalogSwitcher = new SQLEditorCatalogSwitcher(SQLEditorToolBar.this._editor);
                    SQLEditorToolBar.this._catalogToolBarMgr.add((IContributionItem)SQLEditorToolBar.this._catalogSwitcher);
                }
                SQLEditorToolBar.this._coolBarMgr.update(true);
                SQLEditorToolBar.this._coolBar.update();
            }
        });
    }
}

