/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sqlpanel;

import java.sql.SQLException;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditor;
import net.sourceforge.sqlexplorer.plugin.views.SqlResultsView;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;

public abstract class AbstractSQLExecution {
    private Integer _connectionNumber;
    protected boolean _isCancelled = false;
    protected Composite _composite;
    protected SQLEditor _editor;
    private LocalThread _executionThread;
    private Group _group;
    protected TabItem _parentTab;
    private String _progressMessage;
    protected SqlResultsView _resultsView;
    protected SessionTreeNode _session;
    protected String _sqlStatement;
    protected SQLConnection _connection;

    protected final void clearCanvas() {
        if (this._parentTab == null || this._parentTab.isDisposed()) {
            return;
        }
        if (this._isCancelled) {
            return;
        }
        this._parentTab.setText((String)this._parentTab.getData("tabLabel"));
        Control[] children = this._composite.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        this._group = null;
    }

    protected final void displayProgress() {
        this.clearCanvas();
        this._parentTab.setText(Messages.getString("SQLResultsView.Running"));
        GridLayout gLayout = new GridLayout();
        gLayout.numColumns = 2;
        gLayout.marginLeft = 0;
        gLayout.horizontalSpacing = 0;
        gLayout.verticalSpacing = 0;
        gLayout.marginWidth = 0;
        gLayout.marginHeight = 50;
        this._composite.setLayout((Layout)gLayout);
        this._group = new Group(this._composite, 0);
        this._group.setLayout((Layout)new GridLayout());
        this._group.setLayoutData((Object)new GridData(768));
        this._group.setText(this._progressMessage);
        Composite pbComposite = new Composite((Composite)this._group, 4);
        FillLayout pbLayout = new FillLayout();
        pbLayout.marginHeight = 2;
        pbLayout.marginWidth = 5;
        pbComposite.setLayout((Layout)pbLayout);
        pbComposite.setLayoutData((Object)new GridData(768));
        ProgressBar pb = new ProgressBar(pbComposite, 2306);
        pb.setVisible(true);
        pb.setEnabled(true);
        pbComposite.layout();
        this._composite.layout();
    }

    protected abstract void doExecution() throws Exception;

    protected abstract void doStop() throws Exception;

    public final String getSqlStatement() {
        return this._sqlStatement;
    }

    public final void setComposite(Composite composite) {
        this._composite = composite;
    }

    public final void setParentTab(TabItem parentTab) {
        this._parentTab = parentTab;
    }

    public final void setProgressMessage(String progressMessage) {
        this._progressMessage = progressMessage;
        if (this._group != null) {
            this._resultsView.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    AbstractSQLExecution.this._group.setText(AbstractSQLExecution.this._progressMessage);
                    AbstractSQLExecution.this._group.redraw();
                }
            });
        }
    }

    public final void startExecution() {
        this._connectionNumber = this._session.getQueuedConnectionNumber();
        this.displayProgress();
        this._executionThread = new LocalThread();
        this._executionThread.start();
    }

    public final void stop() {
        try {
            this._isCancelled = true;
            this.doStop();
        }
        catch (Exception e) {
            final Shell shell = this._resultsView.getSite().getShell();
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)shell, (String)Messages.getString("SQLResultsView.Error.Title"), (String)e.getMessage());
                }
            });
        }
    }

    private class LocalThread
    extends Thread {
        private LocalThread() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    while (AbstractSQLExecution.this._connection == null && !AbstractSQLExecution.this._isCancelled) {
                        AbstractSQLExecution.this._connection = AbstractSQLExecution.this._session.getQueuedConnection(AbstractSQLExecution.this._connectionNumber);
                        if (AbstractSQLExecution.this._connection != null) continue;
                        LocalThread.sleep(100L);
                    }
                    if (!AbstractSQLExecution.this._isCancelled && AbstractSQLExecution.this._connection != null) {
                        AbstractSQLExecution.this.doExecution();
                    }
                }
                catch (Exception e) {
                    if (!(e instanceof SQLException) && !(e instanceof InterruptedException)) {
                        SQLExplorerPlugin.error("Error executing.", e);
                    }
                    Shell shell = AbstractSQLExecution.this._resultsView.getSite().getShell();
                    shell.getDisplay().asyncExec(new Runnable(this, e, shell){
                        final /* synthetic */ LocalThread this$1;
                        private final /* synthetic */ Exception val$e;
                        private final /* synthetic */ Shell val$shell;
                        {
                            this.this$1 = localThread;
                            this.val$e = exception;
                            this.val$shell = shell;
                        }

                        public void run() {
                            LocalThread.access$1(this.this$1).clearCanvas();
                            if (!(this.val$e instanceof InterruptedException)) {
                                MessageDialog.openError((Shell)this.val$shell, (String)Messages.getString("SQLResultsView.Error.Title"), (String)this.val$e.getMessage());
                            }
                            if (LocalThread.access$1((LocalThread)this.this$1)._parentTab != null) {
                                LocalThread.access$1((LocalThread)this.this$1)._parentTab.dispose();
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                AbstractSQLExecution.this._session.releaseQueuedConnection(AbstractSQLExecution.this._connectionNumber);
                AbstractSQLExecution.this._connection = null;
                throw throwable;
            }
            {
                Object var3_5 = null;
                AbstractSQLExecution.this._session.releaseQueuedConnection(AbstractSQLExecution.this._connectionNumber);
                AbstractSQLExecution.this._connection = null;
                return;
            }
        }

        static /* synthetic */ AbstractSQLExecution access$1(LocalThread localThread) {
            return localThread.AbstractSQLExecution.this;
        }
    }
}

