/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.util;

public class TextUtil {
    public static final int DEFAULT_WRAPLENGTH = 150;
    private static final String NEWLINE_SEPARATOR = "\n";
    private static final String NEWLINE_EXPR = "\\n";
    private static final String RETURN_EXPR = "\\r";
    private static final String TAB_EXPR = "\\t";

    public static String removeLineBreaks(String input) {
        if (input == null) {
            return null;
        }
        String tmp = input.replaceAll(NEWLINE_EXPR, " ");
        tmp = tmp.replaceAll(TAB_EXPR, " ");
        return tmp.replaceAll(RETURN_EXPR, "");
    }

    public static String getWrappedText(String input) {
        return TextUtil.getWrappedText(input, 150);
    }

    public static String getWrappedText(String input, int maxWidth) {
        if (input == null) {
            return "";
        }
        String[] text = input.split(NEWLINE_EXPR);
        String wrappedText = "";
        int i = 0;
        while (i < text.length) {
            text[i] = text[i].replaceAll(RETURN_EXPR, "");
            if (text[i].length() != 0) {
                if (text[i].length() <= maxWidth) {
                    wrappedText = String.valueOf(wrappedText) + text[i];
                    if (i < text.length - 1) {
                        wrappedText = String.valueOf(wrappedText) + NEWLINE_SEPARATOR;
                    }
                } else {
                    String tmp = text[i];
                    block1: while (tmp.length() > maxWidth) {
                        int j = tmp.length() - 1;
                        while (j >= 0) {
                            if (j < maxWidth) {
                                char c = text[i].charAt(j);
                                if (c == ',') {
                                    wrappedText = String.valueOf(wrappedText) + tmp.substring(0, j + 1);
                                    wrappedText = String.valueOf(wrappedText) + NEWLINE_SEPARATOR;
                                    tmp = tmp.substring(j + 1);
                                    continue block1;
                                }
                                if (c == ' ') {
                                    wrappedText = String.valueOf(wrappedText) + tmp.substring(0, j + 1);
                                    wrappedText = String.valueOf(wrappedText) + NEWLINE_SEPARATOR;
                                    tmp = tmp.substring(j + 1);
                                    continue block1;
                                }
                            }
                            if (j == 0) {
                                wrappedText = String.valueOf(wrappedText) + tmp.substring(0, maxWidth + 1);
                                tmp = "";
                                continue block1;
                            }
                            --j;
                        }
                    }
                    wrappedText = String.valueOf(wrappedText) + tmp;
                    wrappedText = String.valueOf(wrappedText) + NEWLINE_SEPARATOR;
                }
            }
            ++i;
        }
        return wrappedText;
    }

    public static String replaceChar(String inputString, char replaceFrom, String replaceTo) {
        if (inputString == null || inputString.length() == 0) {
            return inputString;
        }
        StringBuffer buffer = new StringBuffer();
        char[] input = inputString.toCharArray();
        int i = 0;
        while (i < input.length) {
            if (input[i] == replaceFrom) {
                buffer.append(replaceTo);
            } else {
                buffer.append(input[i]);
            }
            ++i;
        }
        return buffer.toString();
    }
}

