/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import javax.swing.DefaultCellEditor;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewer;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class BaseDataSetViewerDestination
implements IDataSetViewer {
    private static ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$datasetviewer$BaseDataSetViewerDestination == null ? (class$net$sourceforge$squirrel_sql$fw$datasetviewer$BaseDataSetViewerDestination = BaseDataSetViewerDestination.class$("net.sourceforge.squirrel_sql.fw.datasetviewer.BaseDataSetViewerDestination")) : class$net$sourceforge$squirrel_sql$fw$datasetviewer$BaseDataSetViewerDestination);
    private boolean _showHeadings = true;
    protected ColumnDisplayDefinition[] _colDefs = new ColumnDisplayDefinition[0];
    private IDataSetUpdateableModel _updateableModelReference = null;
    protected DefaultCellEditor currentCellEditor = null;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$datasetviewer$BaseDataSetViewerDestination;

    public void init(IDataSetUpdateableModel updateableObject) {
    }

    public void setColumnDefinitions(ColumnDisplayDefinition[] colDefs) {
        this._colDefs = colDefs != null ? colDefs : new ColumnDisplayDefinition[]{};
    }

    public ColumnDisplayDefinition[] getColumnDefinitions() {
        return this._colDefs;
    }

    public void showHeadings(boolean show) {
        this._showHeadings = show;
    }

    public boolean getShowHeadings() {
        return this._showHeadings;
    }

    public synchronized void show(IDataSet ds) throws DataSetException {
        this.show(ds, null);
    }

    public synchronized void show(IDataSet ds, IMessageHandler msgHandler) throws DataSetException {
        if (this.currentCellEditor != null) {
            this.currentCellEditor.cancelCellEditing();
            this.currentCellEditor = null;
        }
        if (ds == null) {
            throw new IllegalArgumentException("IDataSet == null");
        }
        this.clear();
        this.setColumnDefinitions(ds.getDataSetDefinition().getColumnDefinitions());
        int colCount = ds.getColumnCount();
        while (ds.next(msgHandler)) {
            this.addRow(ds, colCount);
        }
        this.allRowsAdded();
        this.moveToTop();
    }

    protected void addRow(IDataSet ds, int columnCount) throws DataSetException {
        Object[] row = new Object[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            row[i] = ds.get(i);
        }
        this.addRow(row);
    }

    public void setUpdateableModelReference(IDataSetUpdateableModel updateableObject) {
        this._updateableModelReference = updateableObject;
    }

    public IDataSetUpdateableModel getUpdateableModelReference() {
        return this._updateableModelReference;
    }

    protected abstract void allRowsAdded() throws DataSetException;

    protected abstract void addRow(Object[] var1) throws DataSetException;

    public static IDataSetViewer getInstance(String sName, IDataSetUpdateableModel updateableModel) {
        IDataSetViewer dsv = null;
        try {
            Class<?> cls = Class.forName(sName);
            dsv = (IDataSetViewer)cls.newInstance();
            dsv.init(updateableModel);
        }
        catch (Exception e) {
            s_log.error("Error", e);
        }
        if (dsv == null) {
            dsv = new DataSetViewerTablePanel();
            ((DataSetViewerTablePanel)dsv).init(updateableModel);
        }
        return dsv;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

