/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.sql.ResultSetReader;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultSetDataSet
implements IDataSet {
    private static final ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$datasetviewer$ResultSetDataSet == null ? (class$net$sourceforge$squirrel_sql$fw$datasetviewer$ResultSetDataSet = ResultSetDataSet.class$("net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet")) : class$net$sourceforge$squirrel_sql$fw$datasetviewer$ResultSetDataSet);
    private int _iCurrent = -1;
    private Object[] _currentRow;
    private int _columnCount;
    private DataSetDefinition _dataSetDefinition;
    private List _alData;
    private boolean _cancel = false;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$datasetviewer$ResultSetDataSet;

    public void setResultSet(ResultSet rs) throws DataSetException {
        this.setResultSet(rs, null, false);
    }

    public void setContentsTabResultSet(ResultSet rs, String fullTableName) throws DataSetException {
        this.setResultSet(rs, fullTableName, null, false, true);
    }

    public void setResultSet(ResultSet rs, int[] columnIndices) throws DataSetException {
        this.setResultSet(rs, columnIndices, false);
    }

    public void setResultSet(ResultSet rs, int[] columnIndices, boolean computeWidths) throws DataSetException {
        this.setResultSet(rs, null, columnIndices, computeWidths, false);
    }

    private void setResultSet(ResultSet rs, String fullTableName, int[] columnIndices, boolean computeWidths, boolean isContentsTab) throws DataSetException {
        this.reset();
        if (columnIndices != null && columnIndices.length == 0) {
            columnIndices = null;
        }
        this._iCurrent = -1;
        this._alData = new ArrayList();
        if (rs != null) {
            try {
                ResultSetMetaData md = rs.getMetaData();
                this._columnCount = columnIndices != null ? columnIndices.length : md.getColumnCount();
                ColumnDisplayDefinition[] colDefs = this.createColumnDefinitions(md, fullTableName, columnIndices, computeWidths);
                this._dataSetDefinition = new DataSetDefinition(colDefs);
                ResultSetReader rdr = new ResultSetReader(rs, null);
                Object[] row = null;
                while ((row = isContentsTab ? rdr.readRow(colDefs) : rdr.readRow()) != null) {
                    if (this._cancel) {
                        return;
                    }
                    if (columnIndices != null) {
                        Object[] newRow = new Object[this._columnCount];
                        for (int i = 0; i < this._columnCount; ++i) {
                            newRow[i] = columnIndices[i] - 1 < row.length ? row[columnIndices[i] - 1] : "Unknown";
                        }
                        row = newRow;
                    }
                    this._alData.add(row);
                }
            }
            catch (SQLException ex) {
                s_log.error("Error reading ResultSet", ex);
                throw new DataSetException(ex);
            }
        }
    }

    public final int getColumnCount() {
        return this._columnCount;
    }

    public DataSetDefinition getDataSetDefinition() {
        return this._dataSetDefinition;
    }

    public synchronized boolean next(IMessageHandler msgHandler) throws DataSetException {
        if (++this._iCurrent < this._alData.size()) {
            this._currentRow = (Object[])this._alData.get(this._iCurrent);
            return true;
        }
        return false;
    }

    public Object get(int columnIndex) {
        return this._currentRow[columnIndex];
    }

    public void cancelProcessing() {
        this._cancel = true;
    }

    private ColumnDisplayDefinition[] createColumnDefinitions(ResultSetMetaData md, String fullTableName, int[] columnIndices, boolean computeWidths) throws SQLException {
        int[] colWidths = null;
        if (computeWidths) {
            colWidths = new int[this._columnCount];
            for (int i = 0; i < this._alData.size(); ++i) {
                Object[] row = (Object[])this._alData.get(i);
                int col = 0;
                while (i < this._columnCount) {
                    int colWidth;
                    if (row[col] != null && (colWidth = row[col].toString().length()) > colWidths[col]) {
                        colWidths[col] = colWidth + 2;
                    }
                    ++i;
                }
            }
        }
        ColumnDisplayDefinition[] columnDefs = new ColumnDisplayDefinition[this._columnCount];
        for (int i = 0; i < this._columnCount; ++i) {
            int precis;
            int idx = columnIndices != null ? columnIndices[i] : i + 1;
            boolean isNullable = true;
            if (md.isNullable(idx) == 0) {
                isNullable = false;
            }
            try {
                precis = md.getPrecision(idx);
            }
            catch (NumberFormatException ignore) {
                precis = Integer.MAX_VALUE;
            }
            boolean isSigned = true;
            try {
                isSigned = md.isSigned(idx);
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            columnDefs[i] = new ColumnDisplayDefinition(computeWidths ? colWidths[i] : md.getColumnDisplaySize(idx), fullTableName + ":" + md.getColumnLabel(idx), md.getColumnLabel(idx), md.getColumnType(idx), md.getColumnTypeName(idx), isNullable, md.getColumnDisplaySize(idx), precis, md.getScale(idx), isSigned, md.isCurrency(idx));
        }
        return columnDefs;
    }

    private void reset() {
        this._iCurrent = -1;
        this._currentRow = null;
        this._columnCount = 0;
        this._dataSetDefinition = null;
        this._alData = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

