/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Calendar;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.border.Border;

public class TimePanel
extends JLabel
implements ActionListener {
    private Timer _timer;
    private DateFormat _fmt = DateFormat.getTimeInstance(1);

    public TimePanel() {
        super("", 0);
    }

    public void addNotify() {
        super.addNotify();
        this._timer = new Timer(1000, this);
        this._timer.start();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }

    public void actionPerformed(ActionEvent evt) {
        this.setText(this._fmt.format(Calendar.getInstance().getTime()));
    }

    public Dimension getPreferredSize() {
        Insets ins;
        Dimension dim = super.getPreferredSize();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Calendar cal = Calendar.getInstance();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        dim.width = fm.stringWidth(this._fmt.format(cal.getTime()));
        Border border = this.getBorder();
        if (border != null && (ins = border.getBorderInsets(this)) != null) {
            dim.width += ins.left + ins.right;
        }
        if ((ins = this.getInsets()) != null) {
            dim.width += ins.left + ins.right;
        }
        return dim;
    }
}

