/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultSetColumnReader {
    private static final ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$sql$ResultSetColumnReader == null ? (class$net$sourceforge$squirrel_sql$fw$sql$ResultSetColumnReader = ResultSetColumnReader.class$("net.sourceforge.squirrel_sql.fw.sql.ResultSetColumnReader")) : class$net$sourceforge$squirrel_sql$fw$sql$ResultSetColumnReader);
    private static final Long LONG_ZERO = new Long(0L);
    private static final Double DOUBLE_ZERO = new Double(0.0);
    private final ResultSet _rs;
    private boolean _wasNull;
    private ResultSetMetaData _rsmd;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$sql$ResultSetColumnReader;

    public ResultSetColumnReader(ResultSet rs) throws SQLException {
        this(rs, null);
    }

    public ResultSetColumnReader(ResultSet rs, int[] columnIndices) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("ResultSet == null");
        }
        this._rs = rs;
        this._rsmd = rs.getMetaData();
    }

    public boolean next() throws SQLException {
        return this._rs.next();
    }

    public Boolean getBoolean(int columnIdx) throws SQLException {
        int columnType;
        Object obj = this._rs.getObject(columnIdx);
        Boolean results = Boolean.FALSE;
        this._wasNull = true;
        if (obj != null && (columnType = this._rsmd.getColumnType(columnIdx)) != 0) {
            this._wasNull = false;
            switch (columnType) {
                case -7: 
                case 16: {
                    if (obj instanceof Boolean) {
                        results = (Boolean)obj;
                        break;
                    }
                    if (obj instanceof Number) {
                        if (((Number)obj).intValue() == 0) {
                            results = Boolean.FALSE;
                            break;
                        }
                        results = Boolean.TRUE;
                        break;
                    }
                    results = Boolean.valueOf(obj.toString());
                    break;
                }
                default: {
                    results = Boolean.valueOf(obj.toString());
                }
            }
        }
        return results;
    }

    public Date getDate(int columnIdx) throws SQLException {
        Date results = this._rs.getDate(columnIdx);
        this._wasNull = results == null;
        return results;
    }

    public Double getDouble(int columnIdx) throws SQLException {
        int columnType;
        Object obj = this._rs.getObject(columnIdx);
        Double results = DOUBLE_ZERO;
        this._wasNull = true;
        if (obj != null && (columnType = this._rsmd.getColumnType(columnIdx)) != 0) {
            this._wasNull = false;
            switch (columnType) {
                case 6: 
                case 7: 
                case 8: {
                    if (obj instanceof Long) {
                        results = (Double)obj;
                        break;
                    }
                    if (obj instanceof Number) {
                        results = new Double(((Number)obj).doubleValue());
                        break;
                    }
                    results = new Double(obj.toString());
                    break;
                }
                default: {
                    results = new Double(obj.toString());
                }
            }
        }
        return results;
    }

    public Long getLong(int columnIdx) throws SQLException {
        int columnType;
        Object obj = this._rs.getObject(columnIdx);
        Long results = LONG_ZERO;
        this._wasNull = true;
        if (obj != null && (columnType = this._rsmd.getColumnType(columnIdx)) != 0) {
            this._wasNull = false;
            switch (columnType) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    if (obj instanceof Long) {
                        results = (Long)obj;
                        break;
                    }
                    if (obj instanceof Number) {
                        results = new Long(((Number)obj).longValue());
                        break;
                    }
                    results = new Long(obj.toString());
                    break;
                }
                default: {
                    results = new Long(obj.toString());
                }
            }
        }
        return results;
    }

    public Object getObject(int columnIdx) throws SQLException {
        Object results = this._rs.getObject(columnIdx);
        this._wasNull = results == null;
        return results;
    }

    public String getString(int columnIdx) throws SQLException {
        String results = this._rs.getString(columnIdx);
        this._wasNull = results == null;
        return results;
    }

    public Time getTime(int columnIdx) throws SQLException {
        Time results = this._rs.getTime(columnIdx);
        this._wasNull = results == null;
        return results;
    }

    public Timestamp getTimeStamp(int columnIdx) throws SQLException {
        Timestamp results = this._rs.getTimestamp(columnIdx);
        this._wasNull = results == null;
        return results;
    }

    public boolean wasNull() {
        return this._wasNull;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

