/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sourceforge.squirrel_sql.fw.sql.DataTypeInfo;
import net.sourceforge.squirrel_sql.fw.sql.ForeignKeyColumnInfo;
import net.sourceforge.squirrel_sql.fw.sql.ForeignKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.IProcedureInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.IUDTInfo;
import net.sourceforge.squirrel_sql.fw.sql.ProcedureInfo;
import net.sourceforge.squirrel_sql.fw.sql.ResultSetColumnReader;
import net.sourceforge.squirrel_sql.fw.sql.ResultSetReader;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableInfo;
import net.sourceforge.squirrel_sql.fw.sql.UDTInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLDatabaseMetaData {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(class$net$sourceforge$squirrel_sql$fw$sql$SQLDatabaseMetaData == null ? (class$net$sourceforge$squirrel_sql$fw$sql$SQLDatabaseMetaData = SQLDatabaseMetaData.class$("net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData")) : class$net$sourceforge$squirrel_sql$fw$sql$SQLDatabaseMetaData);
    private static final ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$sql$SQLDatabaseMetaData == null ? (class$net$sourceforge$squirrel_sql$fw$sql$SQLDatabaseMetaData = SQLDatabaseMetaData.class$("net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData")) : class$net$sourceforge$squirrel_sql$fw$sql$SQLDatabaseMetaData);
    private SQLConnection _conn;
    private Map _cache = new HashMap();
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$sql$SQLDatabaseMetaData;
    static /* synthetic */ Class class$java$lang$String;

    SQLDatabaseMetaData(SQLConnection conn) {
        if (conn == null) {
            throw new IllegalArgumentException("SQLDatabaseMetaData == null");
        }
        this._conn = conn;
    }

    public synchronized String getUserName() throws SQLException {
        String key = "getUserName";
        String value = (String)this._cache.get("getUserName");
        if (value == null) {
            value = this.privateGetJDBCMetaData().getUserName();
            this._cache.put("getUserName", value);
        }
        return value;
    }

    public synchronized String getDatabaseProductName() throws SQLException {
        String key = "getDatabaseProductName";
        String value = (String)this._cache.get("getDatabaseProductName");
        if (value == null) {
            value = this.privateGetJDBCMetaData().getDatabaseProductName();
            this._cache.put("getDatabaseProductName", value);
        }
        return value;
    }

    public synchronized String getDatabaseProductVersion() throws SQLException {
        String key = "getDatabaseProductVersion";
        String value = (String)this._cache.get("getDatabaseProductVersion");
        if (value == null) {
            value = this.privateGetJDBCMetaData().getDatabaseProductVersion();
            this._cache.put("getDatabaseProductVersion", value);
        }
        return value;
    }

    public synchronized String getDriverName() throws SQLException {
        String key = "getDriverName";
        String value = (String)this._cache.get("getDriverName");
        if (value == null) {
            value = this.privateGetJDBCMetaData().getDriverName();
            this._cache.put("getDriverName", value);
        }
        return value;
    }

    public synchronized int getJDBCVersion() throws SQLException {
        String key = "getJDBCVersion";
        Integer value = (Integer)this._cache.get("getJDBCVersion");
        if (value == null) {
            DatabaseMetaData md = this.privateGetJDBCMetaData();
            try {
                Method getMajorVersion = md.getClass().getMethod("getJDBCMajorVersion", null);
                Method getMinorVersion = md.getClass().getMethod("getJDBCMinorVersion", null);
                Integer major = (Integer)getMajorVersion.invoke((Object)md, null);
                Integer minor = (Integer)getMinorVersion.invoke((Object)md, null);
                int vers = major * 100 + minor;
                value = new Integer(vers);
                this._cache.put("getJDBCVersion", value);
            }
            catch (Throwable th) {
                throw new SQLException(s_stringMgr.getString("SQLDatabaseMetaData.unsupported"));
            }
        }
        return value;
    }

    public synchronized String getIdentifierQuoteString() throws SQLException {
        String key = "getIdentifierQuoteString";
        String value = (String)this._cache.get("getIdentifierQuoteString");
        if (value == null) {
            String driverName = this.getDriverName();
            value = driverName.equals("InternetCDS Type 4 JDBC driver for MS SQLServer") || driverName.equals("jConnect (TM) for JDBC (TM)") ? "" : this.privateGetJDBCMetaData().getIdentifierQuoteString();
            this._cache.put("getIdentifierQuoteString", value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String[] getSchemas() throws SQLException {
        String key = "getSchemas";
        String[] value = (String[])this._cache.get("getSchemas");
        if (value != null) {
            return value;
        }
        boolean hasGuest = false;
        String dbProductName = this.getDatabaseProductName();
        boolean isMSSQLorSYBASE = dbProductName.equals("Microsoft SQL Server") || dbProductName.equals("Sybase SQL Server") || dbProductName.equals("SQL Server");
        ArrayList<Object> list = new ArrayList<Object>();
        ResultSet rs = this.privateGetJDBCMetaData().getSchemas();
        try {
            ResultSetReader rdr = new ResultSetReader(rs);
            Object[] row = null;
            while ((row = rdr.readRow()) != null) {
                if (isMSSQLorSYBASE && row[0].equals("guest")) {
                    hasGuest = true;
                }
                list.add(row[0]);
            }
        }
        finally {
            rs.close();
        }
        if (isMSSQLorSYBASE && !hasGuest) {
            list.add("guest");
        }
        value = list.toArray(new String[list.size()]);
        this._cache.put("getSchemas", value);
        return value;
    }

    public boolean supportsSchemas() throws SQLException {
        return this.supportsSchemasInDataManipulation() || this.supportsSchemasInTableDefinitions();
    }

    public synchronized boolean supportsSchemasInDataManipulation() throws SQLException {
        String key = "supportsSchemasInDataManipulation";
        Boolean value = (Boolean)this._cache.get("supportsSchemasInDataManipulation");
        if (value != null) {
            return value;
        }
        try {
            value = new Boolean(this.privateGetJDBCMetaData().supportsSchemasInDataManipulation());
        }
        catch (SQLException ex) {
            if (this.getDriverName().equals("InternetCDS Type 4 JDBC driver for MS SQLServer")) {
                value = Boolean.TRUE;
            }
            throw ex;
        }
        this._cache.put("supportsSchemasInDataManipulation", value);
        return value;
    }

    public synchronized boolean supportsSchemasInTableDefinitions() throws SQLException {
        String key = "supportsSchemasInTableDefinitions";
        Boolean value = (Boolean)this._cache.get("supportsSchemasInTableDefinitions");
        if (value != null) {
            return value;
        }
        try {
            value = new Boolean(this.privateGetJDBCMetaData().supportsSchemasInTableDefinitions());
        }
        catch (SQLException ex) {
            if (this.getDriverName().equals("InternetCDS Type 4 JDBC driver for MS SQLServer")) {
                value = Boolean.TRUE;
            }
            throw ex;
        }
        this._cache.put("supportsSchemasInTableDefinitions", value);
        return value;
    }

    public synchronized boolean supportsStoredProcedures() throws SQLException {
        String key = "supportsStoredProcedures";
        Boolean value = (Boolean)this._cache.get("supportsStoredProcedures");
        if (value != null) {
            return value;
        }
        value = this.getDatabaseProductName().equals("PostgreSQL") ? Boolean.TRUE : new Boolean(this.privateGetJDBCMetaData().supportsStoredProcedures());
        this._cache.put("supportsStoredProcedures", value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String[] getCatalogs() throws SQLException {
        String key = "getCatalogs";
        String[] value = (String[])this._cache.get("getCatalogs");
        if (value != null) {
            return value;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        ResultSet rs = this.privateGetJDBCMetaData().getCatalogs();
        try {
            ResultSetReader rdr = new ResultSetReader(rs);
            Object[] row = null;
            while ((row = rdr.readRow()) != null) {
                list.add(row[0]);
            }
        }
        finally {
            rs.close();
        }
        value = list.toArray(new String[list.size()]);
        this._cache.put("getCatalogs", value);
        return value;
    }

    public synchronized String getCatalogSeparator() throws SQLException {
        String key = "getCatalogSeparator";
        String value = (String)this._cache.get("getCatalogSeparator");
        if (value != null) {
            return value;
        }
        value = this.privateGetJDBCMetaData().getCatalogSeparator();
        this._cache.put("getCatalogSeparator", value);
        return value;
    }

    public boolean supportsCatalogs() throws SQLException {
        return this.supportsCatalogsInTableDefinitions() || this.supportsCatalogsInDataManipulation() || this.supportsCatalogsInProcedureCalls();
    }

    public synchronized boolean supportsCatalogsInTableDefinitions() throws SQLException {
        String key = "supportsCatalogsInTableDefinitions";
        Boolean value = (Boolean)this._cache.get("supportsCatalogsInTableDefinitions");
        if (value != null) {
            return value;
        }
        try {
            value = new Boolean(this.privateGetJDBCMetaData().supportsCatalogsInTableDefinitions());
        }
        catch (SQLException ex) {
            if (this.getDriverName().equals("InternetCDS Type 4 JDBC driver for MS SQLServer")) {
                value = Boolean.TRUE;
            }
            throw ex;
        }
        this._cache.put("supportsCatalogsInTableDefinitions", value);
        return value;
    }

    public synchronized boolean supportsCatalogsInDataManipulation() throws SQLException {
        String key = "supportsCatalogsInDataManipulation";
        Boolean value = (Boolean)this._cache.get("supportsCatalogsInDataManipulation");
        if (value != null) {
            return value;
        }
        try {
            value = new Boolean(this.privateGetJDBCMetaData().supportsCatalogsInDataManipulation());
        }
        catch (SQLException ex) {
            if (this.getDriverName().equals("InternetCDS Type 4 JDBC driver for MS SQLServer")) {
                value = Boolean.TRUE;
            }
            throw ex;
        }
        this._cache.put("supportsCatalogsInDataManipulation", value);
        return value;
    }

    public synchronized boolean supportsCatalogsInProcedureCalls() throws SQLException {
        String key = "supportsCatalogsInProcedureCalls";
        Boolean value = (Boolean)this._cache.get("supportsCatalogsInProcedureCalls");
        if (value != null) {
            return value;
        }
        try {
            value = new Boolean(this.privateGetJDBCMetaData().supportsCatalogsInProcedureCalls());
        }
        catch (SQLException ex) {
            if (this.getDriverName().equals("InternetCDS Type 4 JDBC driver for MS SQLServer")) {
                value = Boolean.TRUE;
            }
            throw ex;
        }
        this._cache.put("supportsCatalogsInProcedureCalls", value);
        return value;
    }

    public synchronized DatabaseMetaData getJDBCMetaData() throws SQLException {
        return this.privateGetJDBCMetaData();
    }

    public ResultSet getTypeInfo() throws SQLException {
        return this.privateGetJDBCMetaData().getTypeInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTypeInfo[] getDataTypes() throws SQLException {
        DatabaseMetaData md = this.privateGetJDBCMetaData();
        ArrayList<DataTypeInfo> list = new ArrayList<DataTypeInfo>();
        ResultSet rs = md.getTypeInfo();
        try {
            ResultSetColumnReader rdr = new ResultSetColumnReader(rs);
            while (rdr.next()) {
                String typeName = rdr.getString(1);
                int dataType = rdr.getLong(2).intValue();
                int precis = rdr.getLong(3).intValue();
                String literalPrefix = rdr.getString(4);
                String literalSuffix = rdr.getString(5);
                String createParams = rdr.getString(6);
                int nullable = rdr.getLong(7).intValue();
                boolean caseSens = rdr.getBoolean(8);
                int searchable = rdr.getLong(9).intValue();
                boolean unsigned = rdr.getBoolean(10);
                boolean canBeMoney = rdr.getBoolean(11);
                boolean canBeAutoInc = rdr.getBoolean(12);
                String localTypeName = rdr.getString(13);
                int min = rdr.getLong(14).intValue();
                int max = rdr.getLong(15).intValue();
                int radix = rdr.getLong(18).intValue();
                list.add(new DataTypeInfo(typeName, dataType, precis, literalPrefix, literalSuffix, createParams, nullable, caseSens, searchable, unsigned, canBeMoney, canBeAutoInc, localTypeName, min, max, radix, this));
            }
        }
        finally {
            rs.close();
        }
        return list.toArray(new DataTypeInfo[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProcedureInfo[] getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        DatabaseMetaData md = this.privateGetJDBCMetaData();
        ArrayList<ProcedureInfo> list = new ArrayList<ProcedureInfo>();
        ResultSet rs = md.getProcedures(catalog, schemaPattern, procedureNamePattern);
        try {
            int[] cols = new int[]{1, 2, 3, 7, 8};
            ResultSetReader rdr = new ResultSetReader(rs, cols);
            Object[] row = null;
            while ((row = rdr.readRow()) != null) {
                int type = ((Number)row[4]).intValue();
                list.add(new ProcedureInfo((String)row[0], (String)row[1], (String)row[2], (String)row[3], type, this));
            }
        }
        finally {
            rs.close();
        }
        return list.toArray(new IProcedureInfo[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String[] getTableTypes() throws SQLException {
        String key = "getTableTypes";
        String[] value = (String[])this._cache.get("getTableTypes");
        if (value != null) {
            return value;
        }
        DatabaseMetaData md = this.privateGetJDBCMetaData();
        TreeSet<String> tableTypes = new TreeSet<String>();
        ResultSet rs = md.getTableTypes();
        if (rs != null) {
            try {
                while (rs.next()) {
                    tableTypes.add(rs.getString(1).trim());
                }
            }
            finally {
                rs.close();
            }
        }
        String dbProductName = this.getDatabaseProductName();
        int nbrTableTypes = tableTypes.size();
        if (nbrTableTypes == 1 && dbProductName.equals("InstantDB")) {
            tableTypes.clear();
            tableTypes.add("TABLE");
            tableTypes.add("SYSTEM TABLE");
        } else if (dbProductName.equals("PostgreSQL") && (nbrTableTypes == 0 || nbrTableTypes == 1)) {
            tableTypes.clear();
            tableTypes.add("TABLE");
            tableTypes.add("SYSTEM TABLE");
            tableTypes.add("VIEW");
            tableTypes.add("INDEX");
            tableTypes.add("SYSTEM INDEX");
            tableTypes.add("SEQUENCE");
        }
        value = tableTypes.toArray(new String[tableTypes.size()]);
        this._cache.put("getTableTypes", value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITableInfo[] getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        DatabaseMetaData md = this.privateGetJDBCMetaData();
        String dbDriverName = this.getDriverName();
        TreeSet<TableInfo> list = new TreeSet<TableInfo>();
        if (dbDriverName.equals("InternetCDS Type 4 JDBC driver for MS SQLServer") && schemaPattern == null) {
            schemaPattern = "dbo";
        }
        HashMap<String, TableInfo> nameMap = null;
        ResultSet superTabResult = null;
        ResultSet tabResult = md.getTables(catalog, schemaPattern, tableNamePattern, types);
        try {
            try {
                Class<?> clazz = md.getClass();
                Class[] p1 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SQLDatabaseMetaData.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SQLDatabaseMetaData.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SQLDatabaseMetaData.class$("java.lang.String")) : class$java$lang$String};
                Method method = clazz.getMethod("getSuperTables", p1);
                if (method != null) {
                    Object[] p2 = new Object[]{catalog, schemaPattern, tableNamePattern};
                    try {
                        superTabResult = (ResultSet)method.invoke((Object)md, p2);
                    }
                    catch (InvocationTargetException ignore) {
                        // empty catch block
                    }
                }
                if (superTabResult != null && superTabResult.next()) {
                    nameMap = new HashMap<String, TableInfo>();
                }
            }
            catch (Throwable th) {
                s_log.debug("DBMS/Driver doesn't support getSupertables()", th);
            }
            while (tabResult.next()) {
                TableInfo tabInfo = new TableInfo(tabResult.getString(1), tabResult.getString(2), tabResult.getString(3), tabResult.getString(4), tabResult.getString(5), this);
                if (nameMap != null) {
                    nameMap.put(tabInfo.getSimpleName(), tabInfo);
                }
                list.add(tabInfo);
            }
            if (nameMap != null) {
                do {
                    TableInfo superInfo;
                    String superTabName;
                    String tabName;
                    TableInfo tabInfo;
                    if ((tabInfo = (TableInfo)nameMap.get(tabName = superTabResult.getString(3))) == null || (superTabName = superTabResult.getString(4)) == null || (superInfo = (TableInfo)nameMap.get(superTabName)) == null) continue;
                    superInfo.addChild(tabInfo);
                    list.remove(tabInfo);
                } while (superTabResult.next());
            }
            Object var17_17 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            tabResult.close();
            if (superTabResult != null) {
                superTabResult.close();
            }
            throw throwable;
        }
        tabResult.close();
        if (superTabResult != null) {
            superTabResult.close();
        }
        return list.toArray(new ITableInfo[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUDTInfo[] getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        DatabaseMetaData md = this.privateGetJDBCMetaData();
        ArrayList<UDTInfo> list = new ArrayList<UDTInfo>();
        ResultSet rs = md.getUDTs(catalog, schemaPattern, typeNamePattern, types);
        try {
            int[] cols = new int[]{1, 2, 3, 4, 5, 6};
            ResultSetReader rdr = new ResultSetReader(rs, cols);
            Object[] row = null;
            while ((row = rdr.readRow()) != null) {
                list.add(new UDTInfo((String)row[0], (String)row[1], (String)row[2], (String)row[3], (String)row[4], (String)row[5], this));
            }
        }
        finally {
            rs.close();
        }
        return list.toArray(new IUDTInfo[list.size()]);
    }

    public synchronized String[] getNumericFunctions() throws SQLException {
        String key = "getNumericFunctions";
        String[] value = (String[])this._cache.get("getNumericFunctions");
        if (value != null) {
            return value;
        }
        value = SQLDatabaseMetaData.makeArray(this.privateGetJDBCMetaData().getNumericFunctions());
        this._cache.put("getNumericFunctions", value);
        return value;
    }

    public synchronized String[] getStringFunctions() throws SQLException {
        String key = "getStringFunctions";
        String[] value = (String[])this._cache.get("getStringFunctions");
        if (value != null) {
            return value;
        }
        value = SQLDatabaseMetaData.makeArray(this.privateGetJDBCMetaData().getStringFunctions());
        this._cache.put("getStringFunctions", value);
        return value;
    }

    public synchronized String[] getSystemFunctions() throws SQLException {
        String key = "getSystemFunctions";
        String[] value = (String[])this._cache.get("getSystemFunctions");
        if (value != null) {
            return value;
        }
        value = SQLDatabaseMetaData.makeArray(this.privateGetJDBCMetaData().getSystemFunctions());
        this._cache.put("getSystemFunctions", value);
        return value;
    }

    public synchronized String[] getTimeDateFunctions() throws SQLException {
        String key = "getTimeDateFunctions";
        String[] value = (String[])this._cache.get("getTimeDateFunctions");
        if (value != null) {
            return value;
        }
        value = SQLDatabaseMetaData.makeArray(this.privateGetJDBCMetaData().getTimeDateFunctions());
        this._cache.put("getTimeDateFunctions", value);
        return value;
    }

    public synchronized String[] getSQLKeywords() throws SQLException {
        String key = "getSQLKeywords";
        String[] value = (String[])this._cache.get("getSQLKeywords");
        if (value != null) {
            return value;
        }
        value = SQLDatabaseMetaData.makeArray(this.privateGetJDBCMetaData().getSQLKeywords());
        this._cache.put("getSQLKeywords", value);
        return value;
    }

    public ResultSet getBestRowIdentifier(ITableInfo ti) throws SQLException {
        return this.privateGetJDBCMetaData().getBestRowIdentifier(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), 1, true);
    }

    public ResultSet getColumnPrivileges(ITableInfo ti) throws SQLException {
        String dbProdName = this.getDatabaseProductName();
        String columns = dbProdName.equalsIgnoreCase("mysql") ? "%" : null;
        return this.privateGetJDBCMetaData().getColumnPrivileges(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), columns);
    }

    public ResultSet getExportedKeys(ITableInfo ti) throws SQLException {
        return this.privateGetJDBCMetaData().getExportedKeys(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
    }

    public ResultSet getImportedKeys(ITableInfo ti) throws SQLException {
        return this.privateGetJDBCMetaData().getImportedKeys(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
    }

    public ForeignKeyInfo[] getImportedKeysInfo(ITableInfo ti) throws SQLException {
        return this.getForeignKeyInfo(this.privateGetJDBCMetaData().getImportedKeys(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName()));
    }

    public ForeignKeyInfo[] getExportedKeysInfo(ITableInfo ti) throws SQLException {
        return this.getForeignKeyInfo(this.privateGetJDBCMetaData().getExportedKeys(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForeignKeyInfo[] getForeignKeyInfo(ResultSet rs) throws SQLException {
        HashMap<String, ForeignKeyInfo> keys = new HashMap<String, ForeignKeyInfo>();
        HashMap columns = new HashMap();
        try {
            ResultSetColumnReader rdr = new ResultSetColumnReader(rs);
            while (rdr.next()) {
                ForeignKeyInfo fki = new ForeignKeyInfo(rdr.getString(1), rdr.getString(2), rdr.getString(3), rdr.getString(5), rdr.getString(6), rdr.getString(7), rdr.getLong(10).intValue(), rdr.getLong(11).intValue(), rdr.getString(12), rdr.getString(13), rdr.getLong(14).intValue(), null, this);
                String key = this.createForeignKeyInfoKey(fki);
                if (!keys.containsKey(key)) {
                    keys.put(key, fki);
                    columns.put(key, new ArrayList());
                }
                ForeignKeyColumnInfo fkiCol = new ForeignKeyColumnInfo(rdr.getString(8), rdr.getString(8), rdr.getLong(9).intValue());
                ((List)columns.get(key)).add(fkiCol);
            }
        }
        finally {
            rs.close();
        }
        ForeignKeyInfo[] results = new ForeignKeyInfo[keys.size()];
        Iterator it = keys.values().iterator();
        int idx = 0;
        while (it.hasNext()) {
            ForeignKeyInfo fki = (ForeignKeyInfo)it.next();
            String key = this.createForeignKeyInfoKey(fki);
            List colsList = (List)columns.get(key);
            ForeignKeyColumnInfo[] fkiCol = colsList.toArray(new ForeignKeyColumnInfo[colsList.size()]);
            fki.setForeignKeyColumnInfo(fkiCol);
            results[idx++] = fki;
        }
        return results;
    }

    private String createForeignKeyInfoKey(ForeignKeyInfo fki) {
        StringBuffer buf = new StringBuffer();
        buf.append(fki.getForeignKeyCatalogName()).append(fki.getForeignKeySchemaName()).append(fki.getForeignKeyTableName()).append(fki.getForeignKeyName()).append(fki.getPrimaryKeyCatalogName()).append(fki.getPrimaryKeySchemaName()).append(fki.getPrimaryKeyTableName()).append(fki.getPrimaryKeyName());
        return buf.toString();
    }

    public ResultSet getIndexInfo(ITableInfo ti) throws SQLException {
        return this.privateGetJDBCMetaData().getIndexInfo(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), false, true);
    }

    public ResultSet getPrimaryKeys(ITableInfo ti) throws SQLException {
        return this.privateGetJDBCMetaData().getPrimaryKeys(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
    }

    public ResultSet getProcedureColumns(IProcedureInfo ti) throws SQLException {
        return this.privateGetJDBCMetaData().getProcedureColumns(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), "%");
    }

    public ResultSet getTablePrivileges(ITableInfo ti) throws SQLException {
        return this.privateGetJDBCMetaData().getTablePrivileges(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
    }

    public ResultSet getVersionColumns(ITableInfo ti) throws SQLException {
        return this.privateGetJDBCMetaData().getVersionColumns(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
    }

    public ResultSet getColumns(ITableInfo ti) throws SQLException {
        return this.privateGetJDBCMetaData().getColumns(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), "%");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableColumnInfo[] getColumnInfo(ITableInfo ti) throws SQLException {
        TreeMap<Integer, TableColumnInfo> columns = new TreeMap<Integer, TableColumnInfo>();
        ResultSet rs = this.getColumns(ti);
        try {
            ResultSetColumnReader rdr = new ResultSetColumnReader(rs);
            while (rdr.next()) {
                TableColumnInfo tci = new TableColumnInfo(rdr.getString(1), rdr.getString(2), rdr.getString(3), rdr.getString(4), rdr.getLong(5).intValue(), rdr.getString(6), rdr.getLong(7).intValue(), rdr.getLong(9).intValue(), rdr.getLong(10).intValue(), rdr.getLong(11).intValue(), rdr.getString(12), rdr.getString(13), rdr.getLong(16).intValue(), rdr.getLong(17).intValue(), rdr.getString(18), this);
                columns.put(new Integer(tci.getOrdinalPosition()), tci);
            }
        }
        finally {
            rs.close();
        }
        return columns.values().toArray(new TableColumnInfo[columns.size()]);
    }

    public boolean correctlySupportsSetMaxRows() throws SQLException {
        return !"i-net OPTA 2000".equals(this.getDriverName());
    }

    public synchronized boolean supportsMultipleResultSets() throws SQLException {
        String key = "supportsMultipleResultSets";
        Boolean value = (Boolean)this._cache.get("supportsMultipleResultSets");
        if (value != null) {
            return value;
        }
        value = new Boolean(this.privateGetJDBCMetaData().supportsMultipleResultSets());
        this._cache.put("supportsMultipleResultSets", value);
        return value;
    }

    public synchronized void clearCache() {
        this._cache.clear();
    }

    private static String[] makeArray(String data) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(data, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }

    private DatabaseMetaData privateGetJDBCMetaData() throws SQLException {
        return this._conn.getConnection().getMetaData();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static interface IDBMSProductNames {
        public static final String MYSQL = "mysql";
        public static final String MICROSOFT_SQL = "Microsoft SQL Server";
        public static final String POSTGRESQL = "PostgreSQL";
        public static final String SYBASE = "Sybase SQL Server";
        public static final String SYBASE_OLD = "SQL Server";
    }

    private static interface IDriverNames {
        public static final String FREE_TDS = "InternetCDS Type 4 JDBC driver for MS SQLServer";
        public static final String JCONNECT = "jConnect (TM) for JDBC (TM)";
        public static final String OPTA2000 = "i-net OPTA 2000";
    }
}

