/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.EventListenerList;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import net.sourceforge.squirrel_sql.fw.util.IObjectCache;
import net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener;
import net.sourceforge.squirrel_sql.fw.util.ObjectCacheChangeEvent;

public class ObjectCache
implements IObjectCache {
    private Map _entries = new HashMap();
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$util$IObjectCacheChangeListener;

    public synchronized IHasIdentifier get(Class objClass, IIdentifier id) {
        return this.getCacheEntry(objClass).get(id);
    }

    public synchronized void add(IHasIdentifier obj) throws DuplicateObjectException {
        this.getCacheEntry(obj.getClass()).add(obj);
    }

    public synchronized void remove(Class objClass, IIdentifier id) {
        this.getCacheEntry(objClass).remove(id);
    }

    public void addChangesListener(IObjectCacheChangeListener lis, Class objClass) {
        this.getCacheEntry(objClass).addChangesListener(lis);
    }

    public void removeChangesListener(IObjectCacheChangeListener lis, Class objClass) {
        this.getCacheEntry(objClass).removeChangesListener(lis);
    }

    public synchronized Class[] getAllClasses() {
        ArrayList classes = new ArrayList();
        Iterator it = this._entries.keySet().iterator();
        while (it.hasNext()) {
            classes.add(it.next());
        }
        if (classes.size() > 0) {
            return classes.toArray(new Class[classes.size()]);
        }
        return new Class[0];
    }

    public synchronized Iterator getAllForClass(Class objClass) {
        return this.getCacheEntry(objClass).values().iterator();
    }

    private CacheEntry getCacheEntry(Class objClass) {
        CacheEntry entry = (CacheEntry)this._entries.get(objClass);
        if (entry == null) {
            entry = new CacheEntry(objClass);
            this._entries.put(objClass, entry);
        }
        return entry;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class CacheEntry {
        private Class _objClass;
        private Map _coll = new HashMap();
        private EventListenerList _listenerList = new EventListenerList();

        CacheEntry(Class objClass) {
            this._objClass = objClass;
        }

        IHasIdentifier get(IIdentifier id) {
            return (IHasIdentifier)this._coll.get(id);
        }

        void add(IHasIdentifier obj) throws DuplicateObjectException, IllegalArgumentException {
            if (this.get(obj.getIdentifier()) != null) {
                throw new DuplicateObjectException(obj);
            }
            if (!this._objClass.isInstance(obj)) {
                throw new IllegalArgumentException("IHasIdentifier is not an instance of " + this._objClass.getName());
            }
            this._coll.put(obj.getIdentifier(), obj);
            this.fireObjectAdded(obj);
        }

        void remove(IIdentifier id) {
            IHasIdentifier obj = this.get(id);
            if (obj != null) {
                this._coll.remove(id);
                this.fireObjectRemoved(obj);
            }
        }

        Collection values() {
            return this._coll.values();
        }

        void addChangesListener(IObjectCacheChangeListener lis) {
            this._listenerList.add(class$net$sourceforge$squirrel_sql$fw$util$IObjectCacheChangeListener == null ? (class$net$sourceforge$squirrel_sql$fw$util$IObjectCacheChangeListener = ObjectCache.class$("net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener")) : class$net$sourceforge$squirrel_sql$fw$util$IObjectCacheChangeListener, lis);
        }

        void removeChangesListener(IObjectCacheChangeListener lis) {
            this._listenerList.remove(class$net$sourceforge$squirrel_sql$fw$util$IObjectCacheChangeListener == null ? (class$net$sourceforge$squirrel_sql$fw$util$IObjectCacheChangeListener = ObjectCache.class$("net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener")) : class$net$sourceforge$squirrel_sql$fw$util$IObjectCacheChangeListener, lis);
        }

        private void fireObjectAdded(IHasIdentifier obj) {
            Object[] listeners = this._listenerList.getListenerList();
            ObjectCacheChangeEvent evt = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$net$sourceforge$squirrel_sql$fw$util$IObjectCacheChangeListener == null ? ObjectCache.class$("net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener") : class$net$sourceforge$squirrel_sql$fw$util$IObjectCacheChangeListener)) continue;
                if (evt == null) {
                    evt = new ObjectCacheChangeEvent(ObjectCache.this, obj);
                }
                ((IObjectCacheChangeListener)listeners[i + 1]).objectAdded(evt);
            }
        }

        private void fireObjectRemoved(IHasIdentifier obj) {
            Object[] listeners = this._listenerList.getListenerList();
            ObjectCacheChangeEvent evt = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$net$sourceforge$squirrel_sql$fw$util$IObjectCacheChangeListener == null ? ObjectCache.class$("net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener") : class$net$sourceforge$squirrel_sql$fw$util$IObjectCacheChangeListener)) continue;
                if (evt == null) {
                    evt = new ObjectCacheChangeEvent(ObjectCache.this, obj);
                }
                ((IObjectCacheChangeListener)listeners[i + 1]).objectRemoved(evt);
            }
        }
    }
}

