/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public class PropertyChangeReporter
implements Serializable {
    private boolean _notify = true;
    private Object _srcBean;
    private PropertyChangeSupport _propChgNotifier;

    public PropertyChangeReporter(Object srcBean) throws IllegalArgumentException {
        if (srcBean == null) {
            throw new IllegalArgumentException("Null srcBean passed");
        }
        this._srcBean = srcBean;
    }

    public void setNotify(boolean value) {
        this._notify = value;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeNotifier().addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeNotifier().removePropertyChangeListener(listener);
    }

    public void firePropertyChange(String propName, Object oldValue, Object newValue) {
        if (this._notify) {
            this.getPropertyChangeNotifier().firePropertyChange(propName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propName, boolean oldValue, boolean newValue) {
        if (this._notify) {
            this.getPropertyChangeNotifier().firePropertyChange(propName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propName, int oldValue, int newValue) {
        if (this._notify) {
            this.getPropertyChangeNotifier().firePropertyChange(propName, oldValue, newValue);
        }
    }

    private PropertyChangeSupport getPropertyChangeNotifier() {
        if (this._propChgNotifier == null) {
            this._propChgNotifier = new PropertyChangeSupport(this._srcBean);
        }
        return this._propChgNotifier;
    }
}

