/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class Utilities {
    private static ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$util$Utilities == null ? (class$net$sourceforge$squirrel_sql$fw$util$Utilities = Utilities.class$("net.sourceforge.squirrel_sql.fw.util.Utilities")) : class$net$sourceforge$squirrel_sql$fw$util$Utilities);
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$util$Utilities;

    private Utilities() {
    }

    public static void printStackTrace(PrintStream ps) {
        if (ps == null) {
            throw new IllegalArgumentException("PrintStream == null");
        }
        try {
            throw new Exception();
        }
        catch (Exception ex) {
            ps.println(Utilities.getStackTrace(ex));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getStackTrace(Throwable th) {
        if (th == null) {
            throw new IllegalArgumentException("Throwable == null");
        }
        StringWriter sw = new StringWriter();
        try {
            PrintWriter pw = new PrintWriter(sw);
            try {
                th.printStackTrace(pw);
                String string = sw.toString();
                return string;
            }
            finally {
                pw.close();
            }
        }
        catch (Throwable throwable2) {
            Object var6_5 = null;
            try {
                sw.close();
                throw throwable2;
            }
            catch (IOException ex) {
                s_log.error("Unexpected error closing StringWriter", ex);
                throw throwable2;
            }
        }
    }

    public static String changeClassNameToFileName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Class Name == null");
        }
        return name.replace('.', '/').concat(".class");
    }

    public static String changeFileNameToClassName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("File Name == null");
        }
        String className = null;
        if (name.toLowerCase().endsWith(".class")) {
            className = name.replace('/', '.');
            className = className.replace('\\', '.');
            className = className.substring(0, className.length() - 6);
        }
        return className;
    }

    public static String cleanString(String str) {
        return StringUtilities.cleanString(str);
    }

    public static boolean areStringsEqual(String s1, String s2) {
        return StringUtilities.areStringsEqual(s1, s2);
    }

    public static String getFileNameSuffix(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("file name == null");
        }
        int pos = fileName.lastIndexOf(46);
        if (pos > 0 && pos < fileName.length() - 1) {
            return fileName.substring(pos + 1);
        }
        return "";
    }

    public static String removeFileNameSuffix(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("file name == null");
        }
        int pos = fileName.lastIndexOf(46);
        if (pos > 0 && pos < fileName.length() - 1) {
            return fileName.substring(0, pos);
        }
        return fileName;
    }

    public static boolean isStringEmpty(String str) {
        return StringUtilities.isEmpty(str);
    }

    public static String formatSize(long longSize) {
        return Utilities.formatSize(longSize, -1);
    }

    public static String formatSize(long longSize, int decimalPos) {
        double size;
        double val;
        NumberFormat fmt = NumberFormat.getNumberInstance();
        if (decimalPos >= 0) {
            fmt.setMaximumFractionDigits(decimalPos);
        }
        if ((val = (size = (double)longSize) / 1048576.0) > 1.0) {
            return fmt.format(val).concat(" MB");
        }
        val = size / 1024.0;
        if (val > 10.0) {
            return fmt.format(val).concat(" KB");
        }
        return fmt.format(val).concat(" bytes");
    }

    public static String[] splitString(String str, char delimiter) {
        return StringUtilities.split(str, delimiter);
    }

    public static String[] splitString(String str, char delimiter, boolean removeEmpty) {
        return StringUtilities.split(str, delimiter, removeEmpty);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

