/*
 * Decompiled with CFR 0.152.
 */
package org.talend.lineage.atlas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.atlas.typesystem.TypesDef;
import org.apache.atlas.typesystem.persistence.Id;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.talend.lineage.atlas.TalendAtlasClient;
import org.talend.lineage.atlas.TalendModelFactory;
import org.talend.lineage.common.AbstractLineageCreator;
import org.talend.lineage.common.ILineageCreator;

public class AtlasLineageCreator
extends AbstractLineageCreator
implements ILineageCreator {
    private static final Logger LOG = Logger.getLogger(AtlasLineageCreator.class);
    @Nullable
    private Referenceable jobRef;
    private List<Referenceable> refs = new ArrayList<Referenceable>();
    private Map<String, Pair<Referenceable, Id>> persistedComponents;
    private Map<String, Pair<Referenceable, Id>> persistedArtificialComponents;
    private Map<String, Pair<Referenceable, Id>> persistedJobs;
    private final TalendAtlasClient client;

    public AtlasLineageCreator(String url, String login, String password) {
        this.client = new TalendAtlasClient(url, login, password);
    }

    @Override
    public void addJobInfo(Map<String, Object> jobMetadata) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("name", jobMetadata.containsKey("name") ? jobMetadata.get("name").toString() : "Talend Job");
        values.put("qualifiedName", jobMetadata.containsKey("name") ? jobMetadata.get("name").toString() + " [" + UUID.randomUUID().toString() + "]" : "Talend Job [" + UUID.randomUUID().toString() + "]");
        values.put("description", jobMetadata.containsKey("description") ? jobMetadata.get("description").toString() : "Talend Job");
        values.put("purpose", jobMetadata.containsKey("purpose") ? jobMetadata.get("purpose").toString() : "Talend Job");
        values.put("author", jobMetadata.containsKey("author") ? jobMetadata.get("author").toString() : "Talend");
        values.put("version", jobMetadata.containsKey("version") ? jobMetadata.get("version").toString() : "");
        values.put("jobType", jobMetadata.containsKey("jobType") ? jobMetadata.get("jobType").toString() : "");
        values.put("framework", jobMetadata.containsKey("framework") ? jobMetadata.get("framework").toString() : "");
        values.put("status", jobMetadata.containsKey("status") ? jobMetadata.get("status").toString() : "FINISHED");
        long creationTime = 0L;
        long lastModificationTime = 0L;
        long startTime = 0L;
        long endTime = 0L;
        try {
            if (jobMetadata.containsKey("creationTime")) {
                creationTime = Long.parseLong(jobMetadata.get("creationTime").toString().trim());
            }
            if (jobMetadata.containsKey("lastModificationTime")) {
                lastModificationTime = Long.parseLong(jobMetadata.get("lastModificationTime").toString().trim());
            }
            if (jobMetadata.containsKey("startTime")) {
                startTime = Long.parseLong(jobMetadata.get("startTime").toString().trim());
            }
            if (jobMetadata.containsKey("endTime")) {
                endTime = Long.parseLong(jobMetadata.get("endTime").toString().trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        values.put("creationTime", creationTime);
        values.put("lastModificationTime", lastModificationTime);
        values.put("startTime", startTime);
        values.put("endTime", endTime);
        this.jobRef = TalendModelFactory.buildTalendJob(values);
    }

    @Override
    public void addNodeToLineage(String name, Map<String, String> schema, List<String> inputNodes, List<String> outputNodes, Map<String, Object> metadata) {
        if (schema.size() > 0) {
            Referenceable ref = TalendModelFactory.buildTalendComponent(name, schema, metadata, inputNodes, outputNodes);
            this.refs.add(ref);
        }
    }

    @Override
    public void sendToLineageProvider(Boolean dieOnError) {
        try {
            Map<String, Pair<Referenceable, Id>> persistedArtificialInstances = this.persistWithArtificialComponents(this.refs);
            if (this.jobRef != null) {
                ArrayList<Object> instancesIds = new ArrayList<Object>();
                for (Pair<Referenceable, Id> pair : this.persistedComponents.values()) {
                    instancesIds.add(pair.getRight());
                }
                this.jobRef.set("components", instancesIds);
                Id idJobRef = this.client.persistInstanceWithLog(this.jobRef);
                String jobName = (String)this.jobRef.get("name");
                this.persistedJobs = new HashMap<String, Pair<Referenceable, Id>>();
                this.persistedJobs.put(jobName, (Pair<Referenceable, Id>)Pair.of((Object)this.jobRef, (Object)idJobRef));
                ArrayList<Id> inputInstanceIds = new ArrayList<Id>();
                for (Pair<Referenceable, Id> pair : this.persistedComponents.values()) {
                    Referenceable ref = (Referenceable)pair.getLeft();
                    List inputs = (List)ref.get("inputs");
                    if (inputs != null && inputs.size() != 0) continue;
                    inputInstanceIds.add((Id)pair.getRight());
                }
                Referenceable artificialRef = TalendModelFactory.buildTalendArtificialComponent(jobName, Arrays.asList(idJobRef), inputInstanceIds);
                Id id = this.client.persistInstanceWithLog(artificialRef);
            }
        }
        catch (Throwable e) {
            if (dieOnError.booleanValue()) {
                throw new RuntimeException(e);
            }
            LOG.error((Object)e);
        }
    }

    private Map<String, Pair<Referenceable, Id>> persistWithArtificialComponents(List<Referenceable> refs) throws Exception {
        this.findOrCreateTypes(TalendModelFactory.TALEND_CLASS_TYPES);
        Map<String, Pair<Referenceable, Id>> persistedInstances = this.persist(refs);
        List<Referenceable> artificialRefs = TalendModelFactory.buildTalendArtificialComponents(persistedInstances);
        Map<String, Pair<Referenceable, Id>> persistedArtificialInstances = this.persist(artificialRefs);
        this.persistedComponents = persistedInstances;
        this.persistedArtificialComponents = persistedArtificialInstances;
        return persistedArtificialInstances;
    }

    private Map<String, Pair<Referenceable, Id>> persist(List<Referenceable> refs) throws Exception {
        HashMap<String, Pair<Referenceable, Id>> persistedEntities = new HashMap<String, Pair<Referenceable, Id>>();
        for (Referenceable ref : refs) {
            Id idRef = this.client.persistInstanceWithLog(ref);
            String name = ref.getValuesMap().get("name").toString();
            persistedEntities.put(name, (Pair<Referenceable, Id>)Pair.of((Object)ref, (Object)idRef));
        }
        return persistedEntities;
    }

    private void findOrCreateTypes(Collection<String> types) throws AtlasServiceException {
        Collection<String> missingTypes = this.client.getMissingTypes(types);
        if (!missingTypes.isEmpty()) {
            TypesDef typesDef = TalendModelFactory.buildTypesDef(missingTypes);
            List<String> list = this.client.persistTypes(typesDef);
        }
    }

    protected void logPersistedEntities() {
        this.logPersistedEntities("persistedJobs:", this.persistedJobs);
        this.logPersistedEntities("persistedEntities:", this.persistedComponents);
        this.logPersistedEntities("persistedArtificialEntities:", this.persistedArtificialComponents);
    }

    private void logPersistedEntities(String msg, @Nullable Map<String, Pair<Referenceable, Id>> entries) {
        LOG.debug((Object)msg);
        if (entries != null) {
            for (Map.Entry<String, Pair<Referenceable, Id>> entry : entries.entrySet()) {
                Referenceable ref = (Referenceable)entry.getValue().getLeft();
                Id id = (Id)entry.getValue().getRight();
                String name = (String)ref.get("name");
                String typeName = ref.getTypeName();
                LOG.debug((Object)(name + " [" + typeName + "] : " + id._getId()));
                if (!"tArtificialComponent".equals(typeName)) continue;
                List inputs = (List)ref.get("inputs");
                List outputs = (List)ref.get("outputs");
                LOG.debug((Object)(name + " inputs  : [" + inputs + "]"));
                LOG.debug((Object)(name + " outputs : [" + outputs + "]"));
            }
        }
    }

    protected List<Referenceable> getRefs() {
        return this.refs;
    }

    @Nullable
    protected Referenceable getJobRef() {
        return this.jobRef;
    }

    protected Map<String, Pair<Referenceable, Id>> getPersistedComponents() {
        return this.persistedComponents;
    }

    protected Map<String, Pair<Referenceable, Id>> getPersistedArtificialComponents() {
        return this.persistedArtificialComponents;
    }

    protected Map<String, Pair<Referenceable, Id>> getPersistedJobs() {
        return this.persistedJobs;
    }
}

