/*
 * Decompiled with CFR 0.152.
 */
package org.talend.lineage.cloudera.entity;

import com.cloudera.nav.sdk.model.SourceType;
import com.cloudera.nav.sdk.model.annotations.MClass;
import com.cloudera.nav.sdk.model.annotations.MRelation;
import com.cloudera.nav.sdk.model.entities.Dataset;
import com.cloudera.nav.sdk.model.entities.Entity;
import com.cloudera.nav.sdk.model.entities.EntityType;
import com.cloudera.nav.sdk.model.entities.HdfsEntity;
import com.cloudera.nav.sdk.model.relations.RelationRole;
import com.google.common.base.Preconditions;
import org.apache.log4j.Logger;
import org.talend.lineage.cloudera.util.GeneratorID;

@MClass(model="talend_dataset")
public class TalendDataset
extends Dataset {
    private static Logger LOG = Logger.getLogger(TalendDataset.class);
    @MRelation(role=RelationRole.PHYSICAL)
    private Entity dataContainer;
    private String componentName;
    private String generatedId;

    public TalendDataset(String name, String componentName, String jobId) {
        this.setSourceType(SourceType.SDK);
        this.setNamespace("Talend");
        this.setName(name);
        this.componentName = componentName;
        this.generatedId = GeneratorID.generateDatasetID(jobId, componentName);
        LOG.debug((Object)("Dataset:" + componentName + " " + jobId + ": " + this.generatedId));
    }

    public String generateId() {
        return this.generatedId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public Entity getDataContainer() {
        return this.dataContainer;
    }

    public void setDataContainer(HdfsEntity hdfsDir) {
        Preconditions.checkArgument((hdfsDir.getEntityType() == EntityType.DIRECTORY ? 1 : 0) != 0);
        this.dataContainer = hdfsDir;
    }
}

