/*
 * Decompiled with CFR 0.152.
 */
package org.talend.lineage.atlas;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.atlas.typesystem.TypesDef;
import org.apache.atlas.typesystem.persistence.Id;
import org.apache.atlas.typesystem.types.AttributeDefinition;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.typesystem.types.HierarchicalTypeDefinition;
import org.apache.atlas.typesystem.types.IDataType;
import org.apache.atlas.typesystem.types.Multiplicity;
import org.apache.atlas.typesystem.types.utils.TypesUtil;
import org.apache.commons.lang3.tuple.Pair;

final class TalendModelFactory {
    private static final String TALEND_JOB_TYPE = "tJob";
    private static final String TALEND_COMPONENT_TYPE = "tComponent";
    private static final String TALEND_ARTIFICIAL_COMPONENT_TYPE = "tArtificialComponent";
    private static final String COLUMN_TYPE = "Column";
    private static final String TALEND_TRAIT = "Talend";
    private static final String TALEND_JOB_TRAIT = "TalendJob";
    private static final String TALEND_COMPONENT_TRAIT = "TalendComponent";
    static final Collection<String> TALEND_CLASS_TYPES = ImmutableList.of((Object)"tJob", (Object)"tComponent", (Object)"tArtificialComponent", (Object)"Column");

    private TalendModelFactory() {
    }

    static TypesDef buildTypesDef(Collection<String> typeNames) {
        HierarchicalTypeDefinition talendTraitDef = TypesUtil.createTraitTypeDef((String)TALEND_TRAIT, null, (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition talendJobTraitDef = TypesUtil.createTraitTypeDef((String)TALEND_JOB_TRAIT, null, (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition talendETLTraitDef = TypesUtil.createTraitTypeDef((String)TALEND_COMPONENT_TRAIT, null, (AttributeDefinition[])new AttributeDefinition[0]);
        HashMap<String, HierarchicalTypeDefinition> allClasses = new HashMap<String, HierarchicalTypeDefinition>();
        HierarchicalTypeDefinition columnClassDef = TypesUtil.createClassTypeDef((String)COLUMN_TYPE, null, (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createOptionalAttrDef((String)"name", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createOptionalAttrDef((String)"dataType", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createOptionalAttrDef((String)"comment", (IDataType)DataTypes.STRING_TYPE)});
        HierarchicalTypeDefinition talendJobClassDef = TypesUtil.createClassTypeDef((String)TALEND_JOB_TYPE, (ImmutableSet)ImmutableSet.of((Object)"DataSet"), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createOptionalAttrDef((String)"purpose", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createOptionalAttrDef((String)"author", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createOptionalAttrDef((String)"version", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createOptionalAttrDef((String)"jobType", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createOptionalAttrDef((String)"framework", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createOptionalAttrDef((String)"creationTime", (IDataType)DataTypes.LONG_TYPE), TypesUtil.createOptionalAttrDef((String)"lastModificationTime", (IDataType)DataTypes.LONG_TYPE), TypesUtil.createOptionalAttrDef((String)"status", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createOptionalAttrDef((String)"startTime", (IDataType)DataTypes.LONG_TYPE), TypesUtil.createOptionalAttrDef((String)"endTime", (IDataType)DataTypes.LONG_TYPE), new AttributeDefinition("components", DataTypes.arrayTypeName((String)TALEND_COMPONENT_TYPE), Multiplicity.COLLECTION, true, null)});
        HierarchicalTypeDefinition talendComponentClassDef = TypesUtil.createClassTypeDef((String)TALEND_COMPONENT_TYPE, (ImmutableSet)ImmutableSet.of((Object)"DataSet"), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createOptionalAttrDef((String)"creationTime", (IDataType)DataTypes.LONG_TYPE), TypesUtil.createOptionalAttrDef((String)"lastModificationTime", (IDataType)DataTypes.LONG_TYPE), TypesUtil.createOptionalAttrDef((String)"startTime", (IDataType)DataTypes.LONG_TYPE), TypesUtil.createOptionalAttrDef((String)"endTime", (IDataType)DataTypes.LONG_TYPE), new AttributeDefinition("columns", DataTypes.arrayTypeName((String)COLUMN_TYPE), Multiplicity.COLLECTION, true, null), TypesUtil.createOptionalAttrDef((String)"script", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createOptionalAttrDef((String)"path", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createOptionalAttrDef((String)"format", (IDataType)DataTypes.STRING_TYPE)});
        HierarchicalTypeDefinition talendArtificialComponentClassDef = TypesUtil.createClassTypeDef((String)TALEND_ARTIFICIAL_COMPONENT_TYPE, (ImmutableSet)ImmutableSet.of((Object)"Process"), (AttributeDefinition[])new AttributeDefinition[0]);
        allClasses.put(COLUMN_TYPE, columnClassDef);
        allClasses.put(TALEND_JOB_TYPE, talendJobClassDef);
        allClasses.put(TALEND_COMPONENT_TYPE, talendComponentClassDef);
        allClasses.put(TALEND_ARTIFICIAL_COMPONENT_TYPE, talendArtificialComponentClassDef);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String typeName : typeNames) {
            HierarchicalTypeDefinition clazz = (HierarchicalTypeDefinition)allClasses.get(typeName);
            if (clazz == null) continue;
            builder.add((Object)clazz);
        }
        ImmutableList classes = builder.build();
        return TypesUtil.getTypesDef((ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of((Object)talendTraitDef, (Object)talendJobTraitDef, (Object)talendETLTraitDef), (ImmutableList)classes);
    }

    static Referenceable buildTalendJob(Map<String, Object> values) {
        return TalendModelFactory.buildReferenceable(TALEND_JOB_TYPE, values, TALEND_TRAIT, TALEND_JOB_TRAIT);
    }

    static Referenceable buildTalendComponent(String name, Map<String, String> schema, Map<String, Object> metadata, List<String> inputs, List<String> outputs) {
        Referenceable ref = TalendModelFactory.buildReferenceable(TALEND_COMPONENT_TYPE, metadata, TALEND_TRAIT, TALEND_COMPONENT_TRAIT);
        ref.set("name", (Object)name);
        ref.set("qualifiedName", (Object)(name + " [" + UUID.randomUUID().toString() + "]"));
        ref.set("columns", TalendModelFactory.buildColumns(schema));
        ref.set("inputs", inputs);
        ref.set("outputs", outputs);
        return ref;
    }

    private static List<Referenceable> buildColumns(Map<String, String> schema) {
        ArrayList<Referenceable> refs = new ArrayList<Referenceable>();
        for (Map.Entry<String, String> entry : schema.entrySet()) {
            Referenceable ref = new Referenceable(COLUMN_TYPE, new String[0]);
            ref.set("name", (Object)entry.getKey());
            ref.set("dataType", (Object)entry.getValue());
            ref.set("comment", (Object)"");
            refs.add(ref);
        }
        return refs;
    }

    static List<Referenceable> buildTalendArtificialComponents(Map<String, Pair<Referenceable, Id>> persistedEntities) {
        LinkedHashMap<String, Referenceable> artificialRefs = new LinkedHashMap<String, Referenceable>();
        for (Map.Entry<String, Pair<Referenceable, Id>> entry : persistedEntities.entrySet()) {
            Referenceable ref = (Referenceable)entry.getValue().getLeft();
            Id id = (Id)entry.getValue().getRight();
            List outputs = (List)ref.get("outputs");
            if (outputs == null || outputs.isEmpty()) continue;
            for (String output : outputs) {
                Referenceable artificialRef = (Referenceable)artificialRefs.get(output);
                if (artificialRef == null) {
                    Id outputId = (Id)persistedEntities.get(output).getRight();
                    artificialRef = TalendModelFactory.buildTalendArtificialComponent(output, Arrays.asList(id), Arrays.asList(outputId));
                } else {
                    List inputs = (List)artificialRef.get("inputs");
                    if (inputs != null) {
                        ArrayList<Id> newInputs = new ArrayList<Id>(inputs);
                        newInputs.add(id);
                        artificialRef.set("inputs", newInputs);
                    }
                }
                artificialRefs.put(output, artificialRef);
            }
        }
        return new ArrayList<Referenceable>(artificialRefs.values());
    }

    static Referenceable buildTalendArtificialComponent(String name, List<Id> inputs, List<Id> outputs) {
        Referenceable ref = new Referenceable(TALEND_ARTIFICIAL_COMPONENT_TYPE, new String[0]);
        ref.set("name", (Object)" ");
        ref.set("qualifiedName", (Object)(name + " [" + UUID.randomUUID().toString() + "]"));
        ref.set("inputs", inputs);
        ref.set("outputs", outputs);
        return ref;
    }

    private static Referenceable buildReferenceable(String refType, Map<String, Object> metadata, String ... traitTypes) {
        Referenceable ref = new Referenceable(refType, traitTypes);
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            ref.set(entry.getKey(), entry.getValue());
        }
        return ref;
    }
}

