/*
 * Decompiled with CFR 0.152.
 */
package org.talend.lineage.cloudera;

import com.cloudera.nav.sdk.model.entities.Entity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.Instant;
import org.talend.lineage.cloudera.NavigatorNode;
import org.talend.lineage.cloudera.entity.TalendEntity;
import org.talend.lineage.cloudera.entity.TalendEntityChild;
import org.talend.lineage.cloudera.entity.TalendInputEntity;
import org.talend.lineage.cloudera.entity.TalendInputOutputEntity;
import org.talend.lineage.cloudera.entity.TalendOutputEntity;
import org.talend.lineage.cloudera.util.ClouderaAPIUtil;
import org.talend.lineage.cloudera.util.GeneratorID;

public class EntityMapper {
    private static final String ENTITY_DESCRIPTION = "Talend Component";
    private static final String ENTITY_LINK = "http://www.talend.com/";
    private List<NavigatorNode> navigatorNodes;
    private String jobId;
    private StringBuilder debugStringBuilder;
    private List<String> tags = new ArrayList<String>();
    private Instant creationInstant;

    public EntityMapper(List<NavigatorNode> navigatorNodes, String jobId) {
        this.navigatorNodes = navigatorNodes;
        this.jobId = jobId;
        this.debugStringBuilder = new StringBuilder();
        this.tags.add("Talend");
        this.creationInstant = new Instant();
    }

    public List<Entity> map() {
        ArrayList<Entity> output = new ArrayList<Entity>();
        if (this.navigatorNodes.size() > 0) {
            for (NavigatorNode navigatorNode : this.navigatorNodes) {
                TalendEntity parentEntity = this.mapToParentEntity(navigatorNode);
                List<TalendEntityChild> childrenEntities = this.mapToChildrenEntities(navigatorNode.getSchema(), parentEntity.getName());
                this.connectChildrenToParent(parentEntity, childrenEntities);
                this.connectChildrenToTarget(navigatorNode, childrenEntities);
                output.addAll(childrenEntities);
                parentEntity.connectToEntity(navigatorNode.getInputNodes(), navigatorNode.getOutputNodes());
                output.add(parentEntity);
                this.addToDebugString(parentEntity, childrenEntities);
            }
            return output;
        }
        throw new IllegalArgumentException("Empty Navigator Nodes list");
    }

    public TalendEntity mapToParentEntity(NavigatorNode navigatorNode) {
        TalendEntity talendEntity;
        List<String> inputNodes = navigatorNode.getInputNodes();
        List<String> outputNodes = navigatorNode.getOutputNodes();
        String componentName = navigatorNode.getName();
        if (CollectionUtils.isNotEmpty(inputNodes) && CollectionUtils.isNotEmpty(outputNodes) || CollectionUtils.isEmpty(inputNodes) && ClouderaAPIUtil.isFileInputOutputComponent(componentName) || CollectionUtils.isEmpty(outputNodes) && ClouderaAPIUtil.isFileInputOutputComponent(componentName)) {
            talendEntity = new TalendInputOutputEntity(this.getJobId(), navigatorNode.getName());
        } else if (CollectionUtils.isEmpty(inputNodes) && CollectionUtils.isNotEmpty(outputNodes)) {
            talendEntity = new TalendInputEntity(this.getJobId(), navigatorNode.getName());
        } else if (CollectionUtils.isNotEmpty(inputNodes) && CollectionUtils.isEmpty(outputNodes)) {
            talendEntity = new TalendOutputEntity(this.getJobId(), navigatorNode.getName());
        } else {
            throw new IllegalArgumentException("Unconnected Navigator Node : " + navigatorNode);
        }
        this.setEntityMetadata(talendEntity);
        return talendEntity;
    }

    public void setEntityMetadata(TalendEntity talendEntity) {
        talendEntity.setDescription(ENTITY_DESCRIPTION);
        talendEntity.setLink(ENTITY_LINK);
        talendEntity.setCreated(this.creationInstant);
        talendEntity.setTags(this.tags);
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public List<TalendEntityChild> mapToChildrenEntities(Map<String, String> schema, String ParentEntityName) {
        ArrayList<TalendEntityChild> output = new ArrayList<TalendEntityChild>();
        for (Map.Entry<String, String> entry : schema.entrySet()) {
            TalendEntityChild talendEntityChild = new TalendEntityChild(this.getJobId(), ParentEntityName, entry.getKey(), entry.getValue());
            this.setChildEntityMetadata(talendEntityChild);
            output.add(talendEntityChild);
        }
        return output;
    }

    public void setChildEntityMetadata(TalendEntityChild talendEntityChild) {
        talendEntityChild.setDescription(ENTITY_DESCRIPTION);
        talendEntityChild.setLink(ENTITY_LINK);
        talendEntityChild.setCreated(this.creationInstant);
    }

    public void connectChildrenToParent(TalendEntity parentEntity, List<TalendEntityChild> children) {
        String idParent = parentEntity.generateId();
        for (TalendEntityChild child : children) {
            child.setParent(parentEntity);
            if (child.getEntityType().equals((Object)"TABLE")) {
                child.addSource(idParent);
                continue;
            }
            child.addSource(child.getEntityId());
        }
    }

    public void connectChildrenToTarget(NavigatorNode navigatorNode, List<TalendEntityChild> children) {
        for (TalendEntityChild talendEntityChild : children) {
            if (CollectionUtils.isEmpty(navigatorNode.getOutputNodes())) {
                String targetComponentId;
                if (ClouderaAPIUtil.isFileInputOutputComponent(navigatorNode.getName())) {
                    targetComponentId = GeneratorID.generateDatasetID(this.getJobId(), navigatorNode.getName());
                    talendEntityChild.addTarget(targetComponentId);
                    continue;
                }
                targetComponentId = GeneratorID.generateNodeID(this.getJobId(), navigatorNode.getName());
                talendEntityChild.addTarget(targetComponentId);
                continue;
            }
            Boolean childConnected = false;
            for (String outputComponent : navigatorNode.getOutputNodes()) {
                if (!ClouderaAPIUtil.isFieldinComponent(outputComponent, talendEntityChild.getName(), this.navigatorNodes).booleanValue()) continue;
                String targetComponentId = GeneratorID.generateEntityChildID(this.getJobId(), outputComponent, talendEntityChild.getName());
                talendEntityChild.addTarget(targetComponentId);
                childConnected = true;
            }
        }
    }

    public void addToDebugString(TalendEntity parentEntity, List<TalendEntityChild> children) {
        this.debugStringBuilder.append("\n" + ((Object)((Object)parentEntity)).toString() + "\n");
        for (TalendEntityChild child : children) {
            this.debugStringBuilder.append("\t" + child.toString() + "\n");
        }
    }

    public String toString() {
        return this.debugStringBuilder.toString();
    }

    public String getJobId() {
        return this.jobId;
    }
}

