/*
 * Decompiled with CFR 0.152.
 */
package org.talend.lineage.cloudera.entity;

import com.cloudera.nav.sdk.model.SourceType;
import com.cloudera.nav.sdk.model.annotations.MClass;
import com.cloudera.nav.sdk.model.annotations.MRelation;
import com.cloudera.nav.sdk.model.entities.EndPointProxy;
import com.cloudera.nav.sdk.model.entities.EntityType;
import com.cloudera.nav.sdk.model.relations.RelationRole;
import java.util.ArrayList;
import java.util.List;
import org.talend.lineage.cloudera.entity.TalendEntity;
import org.talend.lineage.cloudera.util.GeneratorID;

@MClass(model="talend")
public class TalendInputEntity
extends TalendEntity {
    private List<String> nextEntitiesId;
    private List<String> previousEntitiesId;
    @MRelation(role=RelationRole.SOURCE)
    private List<EndPointProxy> sourceProxies;
    @MRelation(role=RelationRole.TARGET)
    private List<EndPointProxy> targetProxies = new ArrayList<EndPointProxy>();

    public TalendInputEntity(String jobId, String componentName) {
        super(jobId, componentName);
        this.sourceProxies = new ArrayList<EndPointProxy>();
        this.nextEntitiesId = new ArrayList<String>();
        this.previousEntitiesId = new ArrayList<String>();
    }

    public void addNextEntity(String entityId) {
        this.nextEntitiesId.add(entityId);
        EndPointProxy endpointProxy = new EndPointProxy(entityId, SourceType.SDK, EntityType.OPERATION_EXECUTION);
        this.targetProxies.add(endpointProxy);
    }

    public void addPreviousEntity(String entityId) {
        this.previousEntitiesId.add(entityId);
        EndPointProxy endpointProxy = new EndPointProxy(entityId, SourceType.SDK, EntityType.OPERATION_EXECUTION);
        this.sourceProxies.add(endpointProxy);
    }

    public List<String> getPreviousEntitiesId() {
        return this.previousEntitiesId;
    }

    public List<String> getNextEntitiesId() {
        return this.nextEntitiesId;
    }

    public List<EndPointProxy> getTargetProxies() {
        return this.targetProxies;
    }

    public List<EndPointProxy> getSourceProxies() {
        return this.sourceProxies;
    }

    public String toString() {
        return this.getName() + " (" + this.getEntityId() + ") --->" + this.nextEntitiesId;
    }

    @Override
    public void connectToEntity(List<String> inputs, List<String> outputs) {
        String idIn = GeneratorID.generateNodeID(this.getJobId(), this.getName());
        this.addPreviousEntity(this.getEntityId());
        for (String output : outputs) {
            String id = GeneratorID.generateNodeID(this.getJobId(), output);
            this.addNextEntity(id);
        }
    }
}

