/*
 * Decompiled with CFR 0.152.
 */
package org.talend.lineage.cloudera.util;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.talend.lineage.cloudera.NavigatorNode;

public class ClouderaAPIUtil {
    public static final String[] FILE_INPUT_OUTPUT_COMPONENT_PREFIXS = new String[]{"tFile", "tHDFS", "tParquet", "tAvro"};

    public static boolean isFileInputOutputComponent(String componentName) {
        for (String prefix : FILE_INPUT_OUTPUT_COMPONENT_PREFIXS) {
            if (!componentName.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static String getDatasetName(String path) {
        if (StringUtils.isNotBlank((String)path)) {
            String[] separatedPath = path.split("/");
            for (int i = separatedPath.length - 1; i >= 0; --i) {
                if (!StringUtils.isNotBlank((String)separatedPath[i])) continue;
                return separatedPath[i];
            }
        }
        return "UnamedTalendDataset";
    }

    public static NavigatorNode retrieveNavigatorNode(String name, List<NavigatorNode> navigatorNodes) {
        for (NavigatorNode navigatorNode : navigatorNodes) {
            if (!name.equals(navigatorNode.getName())) continue;
            return navigatorNode;
        }
        return null;
    }

    public static Boolean isFieldinComponent(String componentName, String fieldName, List<NavigatorNode> navigatorNodes) {
        NavigatorNode outputNavigatorNode = ClouderaAPIUtil.retrieveNavigatorNode(componentName, navigatorNodes);
        return outputNavigatorNode != null && outputNavigatorNode.getSchema().containsKey(fieldName);
    }

    public static String extractNavigatorURL(String navigatorUrl) {
        Pattern compile = Pattern.compile("((?:ht|f)tps?\\:\\/\\/[^:]*:[0-9]*)");
        Matcher matcher = compile.matcher(navigatorUrl);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return navigatorUrl;
    }
}

