/*
 * Decompiled with CFR 0.152.
 */
package org.talend.tns;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import org.talend.tns.TNSParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionManager {
    public static ConnObject getFirstAvailableConnObject(List<TNSParser.TNSEntry> entryList, String user, String pass) {
        ConnObject connObject = new ConnObject();
        Connection conn = null;
        for (TNSParser.TNSEntry entry : entryList) {
            try {
                conn = ConnectionManager.getConn(entry, user, pass);
            }
            catch (Exception e) {
                continue;
            }
            connObject.setConn(conn);
            connObject.setHost(entry.getHost());
            connObject.setPort(entry.getPort());
            connObject.setSid(entry.getSid());
            connObject.setServiceName(entry.getServiceName());
            break;
        }
        return connObject;
    }

    public static Connection getConn(TNSParser.TNSEntry entry, String user, String pass) {
        Connection conn = null;
        String host = entry.getHost();
        int port = entry.getPort();
        String url = null;
        if (entry.getSid() != null) {
            String sid = entry.getSid();
            url = "jdbc:oracle:thin:@" + host + ":" + port + ":" + sid;
        } else {
            String serviceName = entry.getServiceName();
            url = "jdbc:oracle:thin:@(description=(address=(protocol=tcp)(host=" + host + ")(port=" + port + "))(connect_data=(service_name=" + serviceName + ")))";
        }
        try {
            conn = DriverManager.getConnection(url, user, pass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return conn;
    }

    public static class ConnObject {
        private Connection conn;
        private String host;
        private int port;
        private String sid;
        private String serviceName;

        public Connection getConn() {
            return this.conn;
        }

        public void setConn(Connection conn) {
            this.conn = conn;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getSid() {
            return this.sid;
        }

        public void setSid(String sid) {
            this.sid = sid;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }
    }
}

